package com.elitesland.yst.wms.connector.client.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.qimen.api.QimenRequest;

import com.elitesland.yst.wms.connector.client.api.response.InventoryreserveCancelResponse;

/**
 * TOP API: taobao.qimen.inventoryreserve.cancel request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class InventoryreserveCancelRequest extends QimenRequest<InventoryreserveCancelResponse> {
	
	

	/** 
	* 扩展属性
	 */
	private Map extendProps;

	/** 
	* 奇门仓储字段
	 */
	private List<ItemInventory> itemInventories;

	/** 
	* 奇门仓储字段
	 */
	private String orderCode;

	/** 
	* 奇门仓储字段
	 */
	private String orderSource;

	/** 
	* 奇门仓储字段
	 */
	private String ownerCode;

	public void setExtendProps(Map extendProps) {
		this.extendProps = extendProps;
	}

	public Map getExtendProps() {
		return this.extendProps;
	}

	public void setItemInventories(List<ItemInventory> itemInventories) {
		this.itemInventories = itemInventories;
	}

	public List<ItemInventory> getItemInventories() {
		return this.itemInventories;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public String getOrderCode() {
		return this.orderCode;
	}

	public void setOrderSource(String orderSource) {
		this.orderSource = orderSource;
	}

	public String getOrderSource() {
		return this.orderSource;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public String getApiMethodName() {
		return "taobao.qimen.inventoryreserve.cancel";
	}

	public Class<InventoryreserveCancelResponse> getResponseClass() {
		return InventoryreserveCancelResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMaxLength(orderCode, 50, "orderCode");
		RequestCheckUtils.checkMaxLength(orderSource, 50, "orderSource");
		RequestCheckUtils.checkMaxLength(ownerCode, 50, "ownerCode");
	}
	
	/**
 * 奇门仓储字段
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class ItemInventory {

	/**
		 * 奇门仓储字段
		 */
		@ApiField("itemCode")
		private String itemCode;
		/**
		 * 奇门仓储字段
		 */
		@ApiField("itemId")
		private String itemId;
		/**
		 * 奇门仓储字段
		 */
		@ApiField("orderSourceCode")
		private String orderSourceCode;
		/**
		 * 奇门仓储字段
		 */
		@ApiField("subSourceCode")
		private String subSourceCode;
	

	public String getItemCode() {
			return this.itemCode;
		}
		public void setItemCode(String itemCode) {
			this.itemCode = itemCode;
		}
		public String getItemId() {
			return this.itemId;
		}
		public void setItemId(String itemId) {
			this.itemId = itemId;
		}
		public String getOrderSourceCode() {
			return this.orderSourceCode;
		}
		public void setOrderSourceCode(String orderSourceCode) {
			this.orderSourceCode = orderSourceCode;
		}
		public String getSubSourceCode() {
			return this.subSourceCode;
		}
		public void setSubSourceCode(String subSourceCode) {
			this.subSourceCode = subSourceCode;
		}

}


}