package com.elitesland.yst.wms.connector.client.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.internal.mapping.ApiListField;

import com.taobao.api.ApiRuleException;
import com.qimen.api.QimenRequest;

import com.elitesland.yst.wms.connector.client.api.response.InventoryruleCreateResponse;

/**
 * TOP API: taobao.qimen.inventoryrule.create request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class InventoryruleCreateRequest extends QimenRequest<InventoryruleCreateResponse> {
	
	

	/** 
	* inventoryRules
	 */
	private List<InventoryRule> inventoryRules;

	/** 
	* 奇门仓储字段,C1223,string(50),,
	 */
	private String ownerCode;

	public void setInventoryRules(List<InventoryRule> inventoryRules) {
		this.inventoryRules = inventoryRules;
	}

	public List<InventoryRule> getInventoryRules() {
		return this.inventoryRules;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public String getApiMethodName() {
		return "taobao.qimen.inventoryrule.create";
	}

	public Class<InventoryruleCreateResponse> getResponseClass() {
		return InventoryruleCreateResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * channelRatioRules
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("channelRatioRule")
public static class ChannelRatioRule {

	/**
		 * 奇门仓储字段,C1223,string(50),,
		 */
		@ApiField("channelCode")
		private String channelCode;
		/**
		 * 奇门仓储字段,C1223,string(50),,
		 */
		@ApiField("ratio")
		private String ratio;
	

	public String getChannelCode() {
			return this.channelCode;
		}
		public void setChannelCode(String channelCode) {
			this.channelCode = channelCode;
		}
		public String getRatio() {
			return this.ratio;
		}
		public void setRatio(String ratio) {
			this.ratio = ratio;
		}

}

	/**
 * inventoryRules
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("inventoryRule")
public static class InventoryRule {

	/**
		 * 奇门仓储字段,C1223,string(50),,
		 */
		@ApiField("actionType")
		private String actionType;
		/**
		 * channelRatioRules
		 */
		@ApiListField("channelRatioRules")
		@ApiField("channelRatioRule")
		private List<ChannelRatioRule> channelRatioRules;
		/**
		 * 奇门仓储字段,C1223,string(50),,
		 */
		@ApiField("itemCode")
		private String itemCode;
	

	public String getActionType() {
			return this.actionType;
		}
		public void setActionType(String actionType) {
			this.actionType = actionType;
		}
		public List<ChannelRatioRule> getChannelRatioRules() {
			return this.channelRatioRules;
		}
		public void setChannelRatioRules(List<ChannelRatioRule> channelRatioRules) {
			this.channelRatioRules = channelRatioRules;
		}
		public String getItemCode() {
			return this.itemCode;
		}
		public void setItemCode(String itemCode) {
			this.itemCode = itemCode;
		}

}


}