package com.elitesland.yst.wms.connector.client.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.qimen.api.QimenRequest;

import com.elitesland.yst.wms.connector.client.api.response.OrderstatusBatchqueryResponse;

/**
 * TOP API: taobao.qimen.orderstatus.batchquery request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.12
 */
public class OrderstatusBatchqueryRequest extends QimenRequest<OrderstatusBatchqueryResponse> {
	
	

	/** 
	* 当前第几页(从1开始)
	 */
	private Long currentPage;

	/** 
	* 订单最后操作时间(查询截止时间点;格式:YYYY-MM-DD hh:mm:ss)
	 */
	private String endTime;

	/** 
	* 扩展属性
	 */
	private Map extendProps;

	/** 
	* 单据类型(JYCK=一般交易出库单;HHCK=换货出库;BFCK=补发出库;PTCK=普通出库单;DBCK=调拨出库;QTCK=其他出库;B2BRK=B2B入库;B2BCK=B2B出库;CGRK=采购入库;DBRK=调拨入库;QTRK=其他入库;XTRK=销退入库;HHRK= 换货入库;CNJG= 仓内加工单)
	 */
	private String orderType;

	/** 
	* 货主编码
	 */
	private String ownerCode;

	/** 
	* 页面大小(建议不超过100条)
	 */
	private Long pageSize;

	/** 
	* 订单最后操作时间(查询起始时间点;格式:YYYY-MM-DD hh:mm:ss)
	 */
	private String startTime;

	/** 
	* 仓库编码
	 */
	private String warehouseCode;

	public void setCurrentPage(Long currentPage) {
		this.currentPage = currentPage;
	}

	public Long getCurrentPage() {
		return this.currentPage;
	}

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	public String getEndTime() {
		return this.endTime;
	}

	public void setExtendProps(Map extendProps) {
		this.extendProps = extendProps;
	}

	public Map getExtendProps() {
		return this.extendProps;
	}

	public void setOrderType(String orderType) {
		this.orderType = orderType;
	}

	public String getOrderType() {
		return this.orderType;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

	public String getStartTime() {
		return this.startTime;
	}

	public void setWarehouseCode(String warehouseCode) {
		this.warehouseCode = warehouseCode;
	}

	public String getWarehouseCode() {
		return this.warehouseCode;
	}

	public String getApiMethodName() {
		return "taobao.qimen.orderstatus.batchquery";
	}

	public Class<OrderstatusBatchqueryResponse> getResponseClass() {
		return OrderstatusBatchqueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(currentPage, "currentPage");
		RequestCheckUtils.checkMaxLength(endTime, 19, "endTime");
		RequestCheckUtils.checkMaxLength(orderType, 50, "orderType");
		RequestCheckUtils.checkNotEmpty(ownerCode, "ownerCode");
		RequestCheckUtils.checkMaxLength(ownerCode, 50, "ownerCode");
		RequestCheckUtils.checkNotEmpty(pageSize, "pageSize");
		RequestCheckUtils.checkNotEmpty(startTime, "startTime");
		RequestCheckUtils.checkMaxLength(startTime, 19, "startTime");
		RequestCheckUtils.checkMaxLength(warehouseCode, 50, "warehouseCode");
	}
	

}