package com.elitesland.yst.wms.connector.client.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;

import com.taobao.api.ApiRuleException;
import com.qimen.api.QimenRequest;

import com.elitesland.yst.wms.connector.client.api.response.ReceiverinfoQueryResponse;

/**
 * TOP API: taobao.qimen.receiverinfo.query request
 * 
 * @author top auto create
 * @since 1.0, 2021.08.09
 */
public class ReceiverinfoQueryRequest extends QimenRequest<ReceiverinfoQueryResponse> {
	
	

	/** 
	* 出库单号, string (50) , 必填
	 */
	private String deliveryOrderCode;

	/** 
	* 订单收件人 ID, string (50)
	 */
	private String oaid;

	/** 
	* 货主ID
	 */
	private String ownerCode;

	/** 
	* 使用场景。1001，顺丰电子面单发货；1002，4通一达电子面单发货；1003，EMS电子面单发货；1004，其他电子面单发货；2001，客户售后服务
	 */
	private String scene;

	/** 
	* 仓库编码
	 */
	private String warehouseCode;

	public void setDeliveryOrderCode(String deliveryOrderCode) {
		this.deliveryOrderCode = deliveryOrderCode;
	}

	public String getDeliveryOrderCode() {
		return this.deliveryOrderCode;
	}

	public void setOaid(String oaid) {
		this.oaid = oaid;
	}

	public String getOaid() {
		return this.oaid;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public void setScene(String scene) {
		this.scene = scene;
	}

	public String getScene() {
		return this.scene;
	}

	public void setWarehouseCode(String warehouseCode) {
		this.warehouseCode = warehouseCode;
	}

	public String getWarehouseCode() {
		return this.warehouseCode;
	}

	public String getApiMethodName() {
		return "taobao.qimen.receiverinfo.query";
	}

	public Class<ReceiverinfoQueryResponse> getResponseClass() {
		return ReceiverinfoQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(deliveryOrderCode, "deliveryOrderCode");
	}
	

}