package com.elitesland.yst.wms.connector.client.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;

import com.taobao.api.ApiRuleException;
import com.qimen.api.QimenRequest;

import com.elitesland.yst.wms.connector.client.api.response.WarehouseinfoSynchronizeResponse;

/**
 * TOP API: taobao.qimen.warehouseinfo.synchronize request
 * 
 * @author top auto create
 * @since 1.0, 2019.10.23
 */
public class WarehouseinfoSynchronizeRequest extends QimenRequest<WarehouseinfoSynchronizeResponse> {
	
	

	/** 
	* 货主编码，string（50）
	 */
	private String ownerCode;

	/** 
	* 货主名称，string（50）
	 */
	private String ownerName;

	/** 
	* 仓库信息
	 */
	private List<WarehouseInfos> warehouseInfos;

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public void setOwnerName(String ownerName) {
		this.ownerName = ownerName;
	}

	public String getOwnerName() {
		return this.ownerName;
	}

	public void setWarehouseInfos(List<WarehouseInfos> warehouseInfos) {
		this.warehouseInfos = warehouseInfos;
	}

	public List<WarehouseInfos> getWarehouseInfos() {
		return this.warehouseInfos;
	}

	public String getApiMethodName() {
		return "taobao.qimen.warehouseinfo.synchronize";
	}

	public Class<WarehouseinfoSynchronizeResponse> getResponseClass() {
		return WarehouseinfoSynchronizeResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 仓库信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class WarehouseInfos {

	/**
		 * 地区，string（15）
		 */
		@ApiField("area")
		private String area;
		/**
		 * 城市，string（15）
		 */
		@ApiField("city")
		private String city;
		/**
		 * 详细地址，string（50）
		 */
		@ApiField("detailAddress")
		private String detailAddress;
		/**
		 * 负责人手机，string（20）
		 */
		@ApiField("mobile")
		private String mobile;
		/**
		 * 仓库名称，string（50）
		 */
		@ApiField("name")
		private String name;
		/**
		 * 省份，string（15）
		 */
		@ApiField("province")
		private String province;
		/**
		 * 仓库状态，string（20）
		 */
		@ApiField("status")
		private String status;
		/**
		 * 仓库电话，string（20）
		 */
		@ApiField("tel")
		private String tel;
		/**
		 * 乡镇，string（15）
		 */
		@ApiField("town")
		private String town;
		/**
		 * 仓库编码，string（50）
		 */
		@ApiField("warehouseCode")
		private String warehouseCode;
		/**
		 * 仓库名称，string（50）
		 */
		@ApiField("warehouseName")
		private String warehouseName;
	

	public String getArea() {
			return this.area;
		}
		public void setArea(String area) {
			this.area = area;
		}
		public String getCity() {
			return this.city;
		}
		public void setCity(String city) {
			this.city = city;
		}
		public String getDetailAddress() {
			return this.detailAddress;
		}
		public void setDetailAddress(String detailAddress) {
			this.detailAddress = detailAddress;
		}
		public String getMobile() {
			return this.mobile;
		}
		public void setMobile(String mobile) {
			this.mobile = mobile;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public String getProvince() {
			return this.province;
		}
		public void setProvince(String province) {
			this.province = province;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public String getTel() {
			return this.tel;
		}
		public void setTel(String tel) {
			this.tel = tel;
		}
		public String getTown() {
			return this.town;
		}
		public void setTown(String town) {
			this.town = town;
		}
		public String getWarehouseCode() {
			return this.warehouseCode;
		}
		public void setWarehouseCode(String warehouseCode) {
			this.warehouseCode = warehouseCode;
		}
		public String getWarehouseName() {
			return this.warehouseName;
		}
		public void setWarehouseName(String warehouseName) {
			this.warehouseName = warehouseName;
		}

}


}