package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CainiaoEndpointLockerTopOrderNoticeResponse;

/**
 * TOP API: cainiao.endpoint.locker.top.order.notice request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class CainiaoEndpointLockerTopOrderNoticeRequest extends BaseTaobaoRequest<CainiaoEndpointLockerTopOrderNoticeResponse> {
	
	

	/** 
	* 运单号
	 */
	private String mailNo;

	/** 
	* 合作公司唯一订单编号
	 */
	private String orderCode;

	/** 
	* 场景编号：0：重发短信，1：催取短信
	 */
	private Long sceneCode;

	/** 
	* 站点ID
	 */
	private String stationId;

	public void setMailNo(String mailNo) {
		this.mailNo = mailNo;
	}

	public String getMailNo() {
		return this.mailNo;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public String getOrderCode() {
		return this.orderCode;
	}

	public void setSceneCode(Long sceneCode) {
		this.sceneCode = sceneCode;
	}

	public Long getSceneCode() {
		return this.sceneCode;
	}

	public void setStationId(String stationId) {
		this.stationId = stationId;
	}

	public String getStationId() {
		return this.stationId;
	}

	public String getApiMethodName() {
		return "cainiao.endpoint.locker.top.order.notice";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("mail_no", this.mailNo);
		txtParams.put("order_code", this.orderCode);
		txtParams.put("scene_code", this.sceneCode);
		txtParams.put("station_id", this.stationId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CainiaoEndpointLockerTopOrderNoticeResponse> getResponseClass() {
		return CainiaoEndpointLockerTopOrderNoticeResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(mailNo, "mailNo");
		RequestCheckUtils.checkNotEmpty(orderCode, "orderCode");
		RequestCheckUtils.checkNotEmpty(sceneCode, "sceneCode");
		RequestCheckUtils.checkNotEmpty(stationId, "stationId");
	}
	

}