package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CainiaoEndpointLockerTopOrderNoticesendQueryResponse;

/**
 * TOP API: cainiao.endpoint.locker.top.order.noticesend.query request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.19
 */
public class CainiaoEndpointLockerTopOrderNoticesendQueryRequest extends BaseTaobaoRequest<CainiaoEndpointLockerTopOrderNoticesendQueryResponse> {
	
	

	/** 
	* 收件人手机号
	 */
	private String getterPhone;

	/** 
	* 运单号
	 */
	private String mailNo;

	/** 
	* 站点id
	 */
	private String stationId;

	public void setGetterPhone(String getterPhone) {
		this.getterPhone = getterPhone;
	}

	public String getGetterPhone() {
		return this.getterPhone;
	}

	public void setMailNo(String mailNo) {
		this.mailNo = mailNo;
	}

	public String getMailNo() {
		return this.mailNo;
	}

	public void setStationId(String stationId) {
		this.stationId = stationId;
	}

	public String getStationId() {
		return this.stationId;
	}

	public String getApiMethodName() {
		return "cainiao.endpoint.locker.top.order.noticesend.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("getter_phone", this.getterPhone);
		txtParams.put("mail_no", this.mailNo);
		txtParams.put("station_id", this.stationId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CainiaoEndpointLockerTopOrderNoticesendQueryResponse> getResponseClass() {
		return CainiaoEndpointLockerTopOrderNoticesendQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(mailNo, "mailNo");
		RequestCheckUtils.checkNotEmpty(stationId, "stationId");
	}
	

}