package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.CainiaoEndpointLockerTopStationAddorupdateResponse;

/**
 * TOP API: cainiao.endpoint.locker.top.station.addorupdate request
 * 
 * @author top auto create
 * @since 1.0, 2025.03.26
 */
public class CainiaoEndpointLockerTopStationAddorupdateRequest extends BaseTaobaoRequest<CainiaoEndpointLockerTopStationAddorupdateResponse> {
	
	

	/** 
	* 站点信息
	 */
	private String stationInfo;

	public void setStationInfo(String stationInfo) {
		this.stationInfo = stationInfo;
	}

	public void setStationInfo(StationInfo stationInfo) {
		this.stationInfo = new JSONWriter(false,true).write(stationInfo);
	}

	public String getStationInfo() {
		return this.stationInfo;
	}

	public String getApiMethodName() {
		return "cainiao.endpoint.locker.top.station.addorupdate";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("station_info", this.stationInfo);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CainiaoEndpointLockerTopStationAddorupdateResponse> getResponseClass() {
		return CainiaoEndpointLockerTopStationAddorupdateResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 站点信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class StationInfo extends TaobaoObject {

	private static final long serialVersionUID = 2577688466983631824L;

	/**
		 * 城市
		 */
		@ApiField("city")
		private String city;
		/**
		 * 站点联系方式
		 */
		@ApiField("contact")
		private String contact;
		/**
		 * 坐标类型，MARS-火星坐标（高德坐标），BAIDU-百度坐标,GPS-GPS坐标
		 */
		@ApiField("coord_type")
		private String coordType;
		/**
		 * 区县
		 */
		@ApiField("district")
		private String district;
		/**
		 * 站点服务能力描述
		 */
		@ApiField("extra")
		private String extra;
		/**
		 * 小区
		 */
		@ApiField("housing_estate")
		private String housingEstate;
		/**
		 * 站点照片url
		 */
		@ApiField("img_url")
		private String imgUrl;
		/**
		 * 省份
		 */
		@ApiField("province")
		private String province;
		/**
		 * 站点详细地址
		 */
		@ApiField("station_addr")
		private String stationAddr;
		/**
		 * 站点id
		 */
		@ApiField("station_id")
		private String stationId;
		/**
		 * 站点纬度
		 */
		@ApiField("station_lat")
		private String stationLat;
		/**
		 * 站点经度
		 */
		@ApiField("station_lng")
		private String stationLng;
		/**
		 * 站点名字
		 */
		@ApiField("station_name")
		private String stationName;
		/**
		 * 站点编码
		 */
		@ApiField("station_no")
		private String stationNo;
		/**
		 * 站点类型：100-代收点
		 */
		@ApiField("station_type")
		private Long stationType;
		/**
		 * 0-上线，1-下线
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 街道
		 */
		@ApiField("town")
		private String town;
		/**
		 * 邮编
		 */
		@ApiField("zip")
		private String zip;
	

	public String getCity() {
			return this.city;
		}
		public void setCity(String city) {
			this.city = city;
		}
		public String getContact() {
			return this.contact;
		}
		public void setContact(String contact) {
			this.contact = contact;
		}
		public String getCoordType() {
			return this.coordType;
		}
		public void setCoordType(String coordType) {
			this.coordType = coordType;
		}
		public String getDistrict() {
			return this.district;
		}
		public void setDistrict(String district) {
			this.district = district;
		}
		public String getExtra() {
			return this.extra;
		}
		public void setExtra(String extra) {
			this.extra = extra;
		}
		public String getHousingEstate() {
			return this.housingEstate;
		}
		public void setHousingEstate(String housingEstate) {
			this.housingEstate = housingEstate;
		}
		public String getImgUrl() {
			return this.imgUrl;
		}
		public void setImgUrl(String imgUrl) {
			this.imgUrl = imgUrl;
		}
		public String getProvince() {
			return this.province;
		}
		public void setProvince(String province) {
			this.province = province;
		}
		public String getStationAddr() {
			return this.stationAddr;
		}
		public void setStationAddr(String stationAddr) {
			this.stationAddr = stationAddr;
		}
		public String getStationId() {
			return this.stationId;
		}
		public void setStationId(String stationId) {
			this.stationId = stationId;
		}
		public String getStationLat() {
			return this.stationLat;
		}
		public void setStationLat(String stationLat) {
			this.stationLat = stationLat;
		}
		public String getStationLng() {
			return this.stationLng;
		}
		public void setStationLng(String stationLng) {
			this.stationLng = stationLng;
		}
		public String getStationName() {
			return this.stationName;
		}
		public void setStationName(String stationName) {
			this.stationName = stationName;
		}
		public String getStationNo() {
			return this.stationNo;
		}
		public void setStationNo(String stationNo) {
			this.stationNo = stationNo;
		}
		public Long getStationType() {
			return this.stationType;
		}
		public void setStationType(Long stationType) {
			this.stationType = stationType;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public String getTown() {
			return this.town;
		}
		public void setTown(String town) {
			this.town = town;
		}
		public String getZip() {
			return this.zip;
		}
		public void setZip(String zip) {
			this.zip = zip;
		}

}


}