package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.FuwuSpConfirmApplyResponse;

/**
 * TOP API: taobao.fuwu.sp.confirm.apply request
 * 
 * @author top auto create
 * @since 1.0, 2025.03.26
 */
public class FuwuSpConfirmApplyRequest extends BaseTaobaoRequest<FuwuSpConfirmApplyResponse> {
	
	

	/** 
	* 确认单申请
	 */
	private String paramIncomeConfirmDTO;

	public void setParamIncomeConfirmDTO(String paramIncomeConfirmDTO) {
		this.paramIncomeConfirmDTO = paramIncomeConfirmDTO;
	}

	public void setParamIncomeConfirmDTO(IncomeConfirmDto paramIncomeConfirmDTO) {
		this.paramIncomeConfirmDTO = new JSONWriter(false,true).write(paramIncomeConfirmDTO);
	}

	public String getParamIncomeConfirmDTO() {
		return this.paramIncomeConfirmDTO;
	}

	public String getApiMethodName() {
		return "taobao.fuwu.sp.confirm.apply";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_income_confirm_d_t_o", this.paramIncomeConfirmDTO);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<FuwuSpConfirmApplyResponse> getResponseClass() {
		return FuwuSpConfirmApplyResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 确认单申请
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class IncomeConfirmDto extends TaobaoObject {

	private static final long serialVersionUID = 8115863716344521699L;

	/**
		 * appkey
		 */
		@ApiField("appkey")
		private String appkey;
		/**
		 * 确认扩展信息
		 */
		@ApiField("extend")
		private String extend;
		/**
		 * 确认金额
		 */
		@ApiField("fee")
		private Long fee;
		/**
		 * 卖家nick
		 */
		@ApiField("nick")
		private String nick;
		/**
		 * 服务市场有效订单ID
		 */
		@ApiField("order_id")
		private Long orderId;
		/**
		 * 外部确认账单ID
		 */
		@ApiField("out_confirm_id")
		private String outConfirmId;
		/**
		 * 外部订单ID
		 */
		@ApiField("out_order_id")
		private String outOrderId;
	

	public String getAppkey() {
			return this.appkey;
		}
		public void setAppkey(String appkey) {
			this.appkey = appkey;
		}
		public String getExtend() {
			return this.extend;
		}
		public void setExtend(String extend) {
			this.extend = extend;
		}
		public Long getFee() {
			return this.fee;
		}
		public void setFee(Long fee) {
			this.fee = fee;
		}
		public String getNick() {
			return this.nick;
		}
		public void setNick(String nick) {
			this.nick = nick;
		}
		public Long getOrderId() {
			return this.orderId;
		}
		public void setOrderId(Long orderId) {
			this.orderId = orderId;
		}
		public String getOutConfirmId() {
			return this.outConfirmId;
		}
		public void setOutConfirmId(String outConfirmId) {
			this.outConfirmId = outConfirmId;
		}
		public String getOutOrderId() {
			return this.outOrderId;
		}
		public void setOutOrderId(String outOrderId) {
			this.outOrderId = outOrderId;
		}

}


}