package com.elitesland.yst.wms.connector.DTO;

import com.elitesland.yst.wms.connector.config.YstWmsRequestClientConfig;
import com.elitesland.yst.wms.connector.util.LocalDateTimeDeserializer;
import com.elitesland.yst.wms.connector.util.YstHashMap;
//import com.elitesland.yst.wms.connector.taobao.internal.util.TaobaoHashMap;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.http.HttpMethod;

import java.time.LocalDateTime;

/**
 * @author : chen.niu
 * @description : 请求参数
 * @date : 2025-03-25 15:28
 */
@Data
public class YstWmsCallRequestDTO extends YstWmsRequestClientConfig {

    //请求方法名
    private String requestApiMethodName;
    //请求类名
    private String requestClass;
    //返回类名
    private String responseClass;
    //请求参数
    private String requestBodyJson;
    //查询参数
    private YstHashMap queryParam;
    // 客户/仓库/系统 ID 用于判断调用那个wms.  服务器端配置WMS系统对照.
    private String customerId;
    //统一接口类型 如taobao.qimen.entryorder.create
    private String bizType;

    /**
     * 请求方式
     */
    private HttpMethod reqMethod;
    /**
     * 请求头
     */
    private YstHashMap reqHeaders;

    /**
     * 客户端ID
     */
    private String clientId;
    /**
     * 请求者IP
     */
    private String reqIp;
    /**
     * 请求时间
     */
    @JsonDeserialize(using = LocalDateTimeDeserializer.class)
    private LocalDateTime reqTime;
    /**
     * 请求唯一标识,用于关联全部请求
     */
    private String reqUUid;
    /**
     * 请求URI
     */
    private String reqUri;

    private Long reqUserId;
    private String reqUserName;

    @ApiModelProperty("业务参数,用于日志查询,如唯一单据编码或ID")
    private String businessParam; //业务参数,用于日志查询 扩展

}
