package com.elitesland.yst.wms.connector.client.api;

import java.io.Serializable;
import java.util.List;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.QimenErrorField;
import io.swagger.annotations.ApiModelProperty;

/**
 * 奇门API响应包装类。
 * 
 * @author fengsheng
 * @since Jan 27, 2016
 */
public abstract class YstWmsResponse implements Serializable {

	private static final long serialVersionUID = 8987912149522024749L;

	@QimenErrorField("flag")
	@ApiModelProperty("成功失败: success|failure")
	private String flag;

	@QimenErrorField("code")
	private String code;

	@QimenErrorField("message")
	@ApiModelProperty("message")
	private String message;
	@ApiModelProperty("API响应")
	private String body; // API响应XML串


	//业务参数,用于日志查询
	@ApiModelProperty("业务数据参数,如唯一单据编码,用于日志查询")
	private String businessParam;

	public String getBusinessParam() {
		return businessParam;
	}

	public void setBusinessParam(String businessParam) {
		this.businessParam = businessParam;
	}
//	@QimenErrorField("errorMessage")
//	private String errorMessage;
//
//	public String getErrorMessage() {
//		return errorMessage;
//	}

//	public void setErrorMessage(String errorMessage) {
//		this.errorMessage = errorMessage;
//	}

	@QimenErrorField("debugMessages")
	private List<String> debugMessages;
	public List<String> getDebugMessages() {
		return debugMessages;
	}

	public void setDebugMessages(List<String> debugMessages) {
		this.debugMessages = debugMessages;
	}

//	//请求的Uri
//	private String requestUri;
//	public String getRequestUri() {
//		return requestUri;
//	}
//
//	public void setRequestUri(String requestUri) {
//		this.requestUri = requestUri;
//	}


	public String getFlag() {
		return this.flag;
	}

	public void setFlag(String flag) {
		this.flag = flag;
	}

	public String getCode() {
		return this.code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getMessage() {
		return this.message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public String getBody() {
		return this.body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	/**
	 * 判断响应是否成功
	 */
	public boolean isSuccess() {
		return "success".equals(flag);
	}

}
