package com.elitesland.yst.wms.connector.client.api.request;

import com.taobao.api.internal.mapping.ApiField;

import com.taobao.api.ApiRuleException;
import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;

import com.elitesland.yst.wms.connector.client.api.response.InventorySynchronizeResponse;

/**
 * TOP API: taobao.qimen.inventory.synchronize request
 * 
 * @author top auto create
 * @since 1.0, 2023.04.21
 */
public class InventorySynchronizeRequest extends YstWmsRequest<InventorySynchronizeResponse> {
	
	

	/** 
	* 调整单编码,调整单编码,string(50),,
	 */
	private String adjustOrderCode;

	/** 
	* 订单创建时间,订单创建时间,string(50),,
	 */
	private String adjustTime;

	/** 
	* 库存调整类型,库存调整类型,string(50),,
	 */
	private String adjustType;

	/** 
	* 商品列表
	 */
	private Items items;

	/** 
	* 货主编码,货主编码,string(50),,
	 */
	private String ownerCode;

	/** 
	* 关联订单
	 */
	private RelatedOrders relatedOrders;

	/** 
	* 备注,备注,string(50),,
	 */
	private String remark;

	/** 
	* 仓库编码,仓库编码,string(50),,
	 */
	private String warehouseCode;

	public void setAdjustOrderCode(String adjustOrderCode) {
		this.adjustOrderCode = adjustOrderCode;
	}

	public String getAdjustOrderCode() {
		return this.adjustOrderCode;
	}

	public void setAdjustTime(String adjustTime) {
		this.adjustTime = adjustTime;
	}

	public String getAdjustTime() {
		return this.adjustTime;
	}

	public void setAdjustType(String adjustType) {
		this.adjustType = adjustType;
	}

	public String getAdjustType() {
		return this.adjustType;
	}

	public void setItems(Items items) {
		this.items = items;
	}

	public Items getItems() {
		return this.items;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public void setRelatedOrders(RelatedOrders relatedOrders) {
		this.relatedOrders = relatedOrders;
	}

	public RelatedOrders getRelatedOrders() {
		return this.relatedOrders;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getRemark() {
		return this.remark;
	}

	public void setWarehouseCode(String warehouseCode) {
		this.warehouseCode = warehouseCode;
	}

	public String getWarehouseCode() {
		return this.warehouseCode;
	}

	public String getApiMethodName() {
		return "taobao.qimen.inventory.synchronize";
	}

	public Class<InventorySynchronizeResponse> getResponseClass() {
		return InventorySynchronizeResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 关联订单
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class RelatedOrders {

	/**
		 * 关联的订单编号,关联的订单编号,string(50),,
		 */
		@ApiField("orderCode")
		private String orderCode;
		/**
		 * 关联的订单类型,关联的订单类型,string(50),,
		 */
		@ApiField("orderType")
		private String orderType;
	

	public String getOrderCode() {
			return this.orderCode;
		}
		public void setOrderCode(String orderCode) {
			this.orderCode = orderCode;
		}
		public String getOrderType() {
			return this.orderType;
		}
		public void setOrderType(String orderType) {
			this.orderType = orderType;
		}

}

	/**
 * 商品
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Item {

	/**
		 * 批次编码,,string(50),,
		 */
		@ApiField("batchCode")
		private String batchCode;
		/**
		 * 商品过期日期,,string(50),,
		 */
		@ApiField("expireDate")
		private String expireDate;
		/**
		 * 库存类型,,string(50),,
		 */
		@ApiField("inventoryType")
		private String inventoryType;
		/**
		 * 商品编码,,string(50),,
		 */
		@ApiField("itemCode")
		private String itemCode;
		/**
		 * 仓储系统商品ID,,string(50),,
		 */
		@ApiField("itemId")
		private String itemId;
		/**
		 * 调整数量,,string(50),,
		 */
		@ApiField("planQty")
		private String planQty;
		/**
		 * 生产批号,,string(50),,
		 */
		@ApiField("produceCode")
		private String produceCode;
		/**
		 * 商品生产日期,,string(50),,
		 */
		@ApiField("productDate")
		private String productDate;
		/**
		 * 备注,,string(50),,
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 商品序列号,,string(50),,
		 */
		@ApiField("snCode")
		private String snCode;
	

	public String getBatchCode() {
			return this.batchCode;
		}
		public void setBatchCode(String batchCode) {
			this.batchCode = batchCode;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getInventoryType() {
			return this.inventoryType;
		}
		public void setInventoryType(String inventoryType) {
			this.inventoryType = inventoryType;
		}
		public String getItemCode() {
			return this.itemCode;
		}
		public void setItemCode(String itemCode) {
			this.itemCode = itemCode;
		}
		public String getItemId() {
			return this.itemId;
		}
		public void setItemId(String itemId) {
			this.itemId = itemId;
		}
		public String getPlanQty() {
			return this.planQty;
		}
		public void setPlanQty(String planQty) {
			this.planQty = planQty;
		}
		public String getProduceCode() {
			return this.produceCode;
		}
		public void setProduceCode(String produceCode) {
			this.produceCode = produceCode;
		}
		public String getProductDate() {
			return this.productDate;
		}
		public void setProductDate(String productDate) {
			this.productDate = productDate;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSnCode() {
			return this.snCode;
		}
		public void setSnCode(String snCode) {
			this.snCode = snCode;
		}

}

	/**
 * 商品列表
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Items {

	/**
		 * 商品
		 */
		@ApiField("item")
		private Item item;
	

	public Item getItem() {
			return this.item;
		}
		public void setItem(Item item) {
			this.item = item;
		}

}


}