/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.wms.connector.client;

import cn.hutool.core.lang.UUID;
import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitesland.yst.wms.connector.DTO.YstWmsCallRequestDTO;
import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;
import com.elitesland.yst.wms.connector.client.api.YstWmsResponse;
import com.elitesland.yst.wms.connector.config.YstWmsRequestClientConfig;
import com.elitesland.yst.wms.connector.util.CommonUtil;
import com.elitesland.yst.wms.connector.util.YstHashMap;
import com.qimen.api.QimenClient;
import com.taobao.api.ApiException;
import com.taobao.api.internal.cluster.ClusterManager;
import com.taobao.api.internal.cluster.DnsConfig;
import java.time.LocalDateTime;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class YstWmsRequestClient
implements QimenClient {
    public static final String APP_KEY = "AppKey";
    public static final String APP_SECRET = "AppSecret";
    public static final String API_METHOD_NAME = "ApiMethodName";
    public static final String RESPONSE_CLASS = "ResponseClass";
    public static final String REQUEST_CLASS = "RequestClass";
    public static final String ACTIVE_CALL_API_URL = "/wms/router/active/call";
    public static final String PASSIVE_CALL_API_URL = "/wms/router/passive/call";
    protected String format = "xml";
    protected String signMethod = "md5";
    protected int connectTimeout = 15000;
    protected int readTimeout = 30000;
    protected boolean needEnableParser = true;
    protected boolean useGzipEncoding = true;
    private boolean isHttpDnsEnabled = false;
    private String originalHttpHost = null;
    private YstWmsRequestClientConfig ystWmsRequestClientConfig;
    private RestTemplate restTemplate = new RestTemplate();
    private YstWmsCallRequestDTO ystWmsRequestDTO;

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public YstWmsRequestClient(YstWmsRequestClientConfig ystWmsRequestClientConfig) {
        ystWmsRequestClientConfig.validateConfig();
        this.ystWmsRequestClientConfig = ystWmsRequestClientConfig;
    }

    @Override
    public <T extends YstWmsResponse> T execute(YstWmsRequest<T> request) throws ApiException {
        return this.execute(request, null);
    }

    @Override
    public <T extends YstWmsResponse> T execute(YstWmsRequest<T> request, String session) throws ApiException {
        return this._execute(request, session);
    }

    public YstWmsCallRequestDTO getExecuteYstWmsRequestDTO() {
        return this.ystWmsRequestDTO;
    }

    private <T extends YstWmsResponse> T _execute(YstWmsRequest<T> request, String session) throws ApiException {
        long start = System.currentTimeMillis();
        String realServerUrl = this.ystWmsRequestClientConfig.getServerBaseUrl();
        try {
            this.ystWmsRequestDTO = this.getYstWmsRequestDTO(request);
            String apiBody = JSONUtil.toJsonStr((Object)this.ystWmsRequestDTO);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity entity = new HttpEntity((Object)apiBody, (MultiValueMap)headers);
            String response = (String)this.restTemplate.exchange(realServerUrl + ACTIVE_CALL_API_URL, HttpMethod.POST, entity, String.class, new Object[0]).getBody();
            return (T)((YstWmsResponse)JSONUtil.toBean((String)response, request.getResponseClass()));
        }
        catch (Exception var17) {
            var17.printStackTrace();
            throw new ApiException(var17);
        }
    }

    @NotNull
    public <T extends YstWmsResponse> YstWmsCallRequestDTO getYstWmsRequestDTO(YstWmsRequest<T> request) {
        String requestJson = JSONUtil.toJsonStr(request);
        YstWmsCallRequestDTO ystWmsRequestDTO = new YstWmsCallRequestDTO();
        ystWmsRequestDTO.setSourceAppCode(this.ystWmsRequestClientConfig.getSourceAppCode());
        ystWmsRequestDTO.setSourceSysCode(this.ystWmsRequestClientConfig.getSourceSysCode());
        ystWmsRequestDTO.setSourceAppSecret(this.ystWmsRequestClientConfig.getSourceAppSecret());
        ystWmsRequestDTO.setCustomerId(request.getCustomerId());
        ystWmsRequestDTO.setReqUserId(request.getReqUserId());
        ystWmsRequestDTO.setReqUserName(request.getReqUserName());
        ystWmsRequestDTO.setWmsSysCode(this.ystWmsRequestClientConfig.getWmsSysCode());
        ystWmsRequestDTO.setServerBaseUrl(this.ystWmsRequestClientConfig.getServerBaseUrl());
        ystWmsRequestDTO.setQueryParam((YstHashMap)request.getQueryParams());
        ystWmsRequestDTO.setRequestApiMethodName(request.getApiMethodName());
        ystWmsRequestDTO.setRequestBodyJson(requestJson);
        ystWmsRequestDTO.setRequestClass(request.getClass().getName());
        ystWmsRequestDTO.setResponseClass(request.getResponseClass().getName());
        ystWmsRequestDTO.setBizType(request.getApiMethodName());
        ystWmsRequestDTO.setReqMethod(HttpMethod.POST);
        ystWmsRequestDTO.setClientId("YstWmsRequestClient");
        ystWmsRequestDTO.setReqIp(HttpServletUtil.currentClientIp() != null ? HttpServletUtil.currentClientIp() : CommonUtil.getServerIp());
        ystWmsRequestDTO.setReqTime(LocalDateTime.now());
        try {
            ystWmsRequestDTO.setReqUUid(TraceContext.traceId() + ":" + UUID.randomUUID());
        }
        catch (Exception e) {
            System.out.println("ystWmsRequestDTO.setReqUUid error:" + e.getMessage());
            ystWmsRequestDTO.setReqUUid("NULL:" + UUID.randomUUID());
        }
        ystWmsRequestDTO.setReqUri(this.ystWmsRequestClientConfig.getServerBaseUrl() + ACTIVE_CALL_API_URL);
        ystWmsRequestDTO.setBusinessParam(request.getBusinessParam());
        return ystWmsRequestDTO;
    }

    public String getServerUrl(String serverUrl) {
        if (this.isHttpDnsEnabled) {
            DnsConfig dnsConfig = ClusterManager.GetDnsConfigFromCache();
            return dnsConfig == null ? serverUrl : dnsConfig.getVipUrl(serverUrl);
        }
        return serverUrl;
    }
}

