/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.frame.rfc6455;

import com.taobao.api.internal.toplink.embedded.websocket.frame.Frame;
import com.taobao.api.internal.toplink.embedded.websocket.frame.rfc6455.BinaryFrame;
import com.taobao.api.internal.toplink.embedded.websocket.frame.rfc6455.CloseFrame;
import com.taobao.api.internal.toplink.embedded.websocket.frame.rfc6455.FrameHeaderRfc6455;
import com.taobao.api.internal.toplink.embedded.websocket.frame.rfc6455.PingFrame;
import com.taobao.api.internal.toplink.embedded.websocket.frame.rfc6455.PongFrame;
import com.taobao.api.internal.toplink.embedded.websocket.frame.rfc6455.TextFrame;
import java.nio.ByteBuffer;

public class FrameBuilderRfc6455 {
    protected static final int MAX_FRAME_LENGTH_16 = 65535;
    protected static final long MAX_FRAME_LENGTH_63 = Long.MAX_VALUE;
    protected static final int FIN_MASK = 128;
    protected static final byte RSV1_MASK = 64;
    protected static final byte RSV2_MASK = 32;
    protected static final byte RSV3_MASK = 16;
    protected static final byte OPCODE_MASK = 15;
    protected static final int MASK_MASK = 128;
    protected static final int PAYLOAD_LEN_MASK = 127;

    public static FrameHeaderRfc6455 createFrameHeader(ByteBuffer chunkData, FrameHeaderRfc6455 previousHeader) {
        boolean fragmented;
        if (chunkData == null) {
            throw new IllegalArgumentException("Data is null.");
        }
        int length = chunkData.limit() - chunkData.position();
        if (length < 2) {
            return null;
        }
        byte hb1 = chunkData.get();
        boolean bl = fragmented = (hb1 & 0x80) == 0;
        if ((hb1 & 0x70) != 0) {
            throw new IllegalArgumentException("Found nonzero bit in reserve field. (RSV1,2,3)");
        }
        int opcodeNum = hb1 & 0xF;
        Opcode opcode = Opcode.valueOf(opcodeNum);
        if (opcode == null) {
            throw new IllegalArgumentException("Found illegal opcode " + opcodeNum + ".");
        }
        byte hb2 = chunkData.get();
        if ((hb2 & 0x80) != 0) {
            throw new IllegalArgumentException("Found mask bit field. (MASK)");
        }
        byte payloadLength1 = (byte)(hb2 & 0x7F);
        PayloadLengthType payloadLengthType = PayloadLengthType.valueOf(payloadLength1);
        if (payloadLengthType == null) {
            throw new IllegalArgumentException("Found illegal payload length " + payloadLength1 + ".");
        }
        if (length < 2 + payloadLengthType.offset()) {
            return null;
        }
        long payloadLength2 = payloadLength1;
        switch (payloadLengthType) {
            case LEN_16: {
                payloadLength2 = (chunkData.get() & 0xFF) << 8 | chunkData.get() & 0xFF;
                break;
            }
            case LEN_63: {
                payloadLength2 = Long.MAX_VALUE & chunkData.getLong();
                break;
            }
        }
        if (payloadLength2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("large data is not support yet");
        }
        if (Opcode.CONTINUATION.equals((Object)opcode) && previousHeader != null) {
            return new FrameHeaderRfc6455(fragmented, 2, payloadLengthType, (int)payloadLength2, opcode, previousHeader.getOpcode());
        }
        return new FrameHeaderRfc6455(fragmented, 2, payloadLengthType, (int)payloadLength2, opcode);
    }

    public static FrameHeaderRfc6455 createFrameHeader(byte[] body, boolean fragmented, Opcode opcode) {
        int payloadLength = 0;
        if (body != null) {
            payloadLength = body.length;
        }
        PayloadLengthType payloadLengthType = PayloadLengthType.valueOf(payloadLength);
        return new FrameHeaderRfc6455(fragmented, 2, payloadLengthType, payloadLength, opcode);
    }

    public static Frame createFrame(FrameHeaderRfc6455 header, byte[] bodyData) {
        Opcode opcode = header.getRealOpcode();
        if (opcode == null) {
            opcode = header.getOpcode();
        }
        switch (opcode) {
            case CONNECTION_CLOSE: {
                return new CloseFrame(header, bodyData);
            }
            case PING: {
                return new PingFrame(header, bodyData);
            }
            case PONG: {
                return new PongFrame(header, bodyData);
            }
            case TEXT_FRAME: {
                return new TextFrame(header, bodyData);
            }
            case BINARY_FRAME: {
                return new BinaryFrame(header, bodyData);
            }
        }
        throw new IllegalStateException("Not found Opcode type!");
    }

    protected static enum Opcode {
        CONTINUATION(0),
        TEXT_FRAME(1),
        BINARY_FRAME(2),
        CONNECTION_CLOSE(8),
        PING(9),
        PONG(10);

        private final int opcode;

        private Opcode(int opcode) {
            this.opcode = opcode;
        }

        public int intValue() {
            return this.opcode;
        }

        public static Opcode valueOf(int opc) {
            switch (opc) {
                case 0: {
                    return CONTINUATION;
                }
                case 1: {
                    return TEXT_FRAME;
                }
                case 2: {
                    return BINARY_FRAME;
                }
                case 8: {
                    return CONNECTION_CLOSE;
                }
                case 9: {
                    return PING;
                }
                case 10: {
                    return PONG;
                }
            }
            return null;
        }
    }

    protected static enum PayloadLengthType {
        LEN_SHORT(125, 0),
        LEN_16(126, 2),
        LEN_63(127, 8);

        private final byte payloadLengthType;
        private final int offset;

        private PayloadLengthType(byte payloadLengthType, int offset) {
            this.payloadLengthType = payloadLengthType;
            this.offset = offset;
        }

        public byte byteValue() {
            return this.payloadLengthType;
        }

        public int offset() {
            return this.offset;
        }

        public static PayloadLengthType valueOf(byte plt) {
            switch (plt) {
                case 126: {
                    return LEN_16;
                }
                case 127: {
                    return LEN_63;
                }
            }
            if (0 <= plt && plt <= 125) {
                return LEN_SHORT;
            }
            return null;
        }

        public static PayloadLengthType valueOf(long payloadLength) {
            if (payloadLength <= (long)LEN_SHORT.byteValue()) {
                return LEN_SHORT;
            }
            if (payloadLength <= 65535L) {
                return LEN_16;
            }
            if (payloadLength <= Long.MAX_VALUE) {
                return LEN_63;
            }
            throw new IllegalArgumentException("Overflow payload length. payloadLength: " + payloadLength);
        }
    }

    protected static enum Rsv {
        RESERVE(0);

        private final int rsv;

        private Rsv(int rsv) {
            this.rsv = rsv;
        }

        public int intValue() {
            return this.rsv;
        }
    }

    protected static enum Fin {
        MORE_FRAME(0),
        FINAL(1);

        private final int fin;

        private Fin(int fin) {
            this.fin = fin;
        }

        public int intValue() {
            return this.fin;
        }
    }
}

