package com.elitesland.yst.wms.connector.client.api.request;

import com.taobao.api.internal.mapping.ApiField;

import com.taobao.api.ApiRuleException;
import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;

import com.elitesland.yst.wms.connector.client.api.response.ReturnpackageReportResponse;

/**
 * TOP API: taobao.qimen.returnpackage.report request
 * 
 * @author top auto create
 * @since 1.0, 2019.03.12
 */
public class ReturnpackageReportRequest extends YstWmsRequest<ReturnpackageReportResponse> {
	
	

	/** 
	* 订单
	 */
	private Order order;

	/** 
	* 包裹列表
	 */
	private Packages packages;

	public void setOrder(Order order) {
		this.order = order;
	}

	public Order getOrder() {
		return this.order;
	}

	public void setPackages(Packages packages) {
		this.packages = packages;
	}

	public Packages getPackages() {
		return this.packages;
	}

	public String getApiMethodName() {
		return "taobao.qimen.returnpackage.report";
	}

	public Class<ReturnpackageReportResponse> getResponseClass() {
		return ReturnpackageReportResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 订单
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Order {

	/**
		 * 退货包裹交接单编码, string (50) , 必填
		 */
		@ApiField("orderCode")
		private String orderCode;
		/**
		 * 单据类型, string（50）,THPL=退货包裹交接单
		 */
		@ApiField("orderType")
		private String orderType;
		/**
		 * 外部业务编码, 消息ID, 用于去重, ISV对于同一请求，分配一个唯一性的编码。用来保证因为网络等原因导致重复传输，请求不会被重复处理。必填
		 */
		@ApiField("outBizCode")
		private String outBizCode;
		/**
		 * 货主编码, string (50) , 必填
		 */
		@ApiField("ownerCode")
		private String ownerCode;
		/**
		 * 仓库编码, string (50)，必填
		 */
		@ApiField("warehouseCode")
		private String warehouseCode;
	

	public String getOrderCode() {
			return this.orderCode;
		}
		public void setOrderCode(String orderCode) {
			this.orderCode = orderCode;
		}
		public String getOrderType() {
			return this.orderType;
		}
		public void setOrderType(String orderType) {
			this.orderType = orderType;
		}
		public String getOutBizCode() {
			return this.outBizCode;
		}
		public void setOutBizCode(String outBizCode) {
			this.outBizCode = outBizCode;
		}
		public String getOwnerCode() {
			return this.ownerCode;
		}
		public void setOwnerCode(String ownerCode) {
			this.ownerCode = ownerCode;
		}
		public String getWarehouseCode() {
			return this.warehouseCode;
		}
		public void setWarehouseCode(String warehouseCode) {
			this.warehouseCode = warehouseCode;
		}

}

	/**
 * 商品详情
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Item {

	/**
		 * 金额
		 */
		@ApiField("amount")
		private String amount;
		/**
		 * 商品编码
		 */
		@ApiField("itemCode")
		private String itemCode;
		/**
		 * 商品仓储系统编码
		 */
		@ApiField("itemId")
		private String itemId;
		/**
		 * 商品名称
		 */
		@ApiField("itemName")
		private String itemName;
		/**
		 * 商品单价
		 */
		@ApiField("price")
		private String price;
		/**
		 * 包裹内该商品的数量,
		 */
		@ApiField("quantity")
		private String quantity;
		/**
		 * 签收状态
		 */
		@ApiField("status")
		private String status;
		/**
		 * 商品单位
		 */
		@ApiField("unit")
		private String unit;
	

	public String getAmount() {
			return this.amount;
		}
		public void setAmount(String amount) {
			this.amount = amount;
		}
		public String getItemCode() {
			return this.itemCode;
		}
		public void setItemCode(String itemCode) {
			this.itemCode = itemCode;
		}
		public String getItemId() {
			return this.itemId;
		}
		public void setItemId(String itemId) {
			this.itemId = itemId;
		}
		public String getItemName() {
			return this.itemName;
		}
		public void setItemName(String itemName) {
			this.itemName = itemName;
		}
		public String getPrice() {
			return this.price;
		}
		public void setPrice(String price) {
			this.price = price;
		}
		public String getQuantity() {
			return this.quantity;
		}
		public void setQuantity(String quantity) {
			this.quantity = quantity;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public String getUnit() {
			return this.unit;
		}
		public void setUnit(String unit) {
			this.unit = unit;
		}

}

	/**
 * 商品列表
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Items {

	/**
		 * 商品详情
		 */
		@ApiField("item")
		private Item item;
	

	public Item getItem() {
			return this.item;
		}
		public void setItem(Item item) {
			this.item = item;
		}

}

	/**
 * 包裹详情
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Package {

	/**
		 * 运单号, string (50) , 不必填
		 */
		@ApiField("expressCode")
		private String expressCode;
		/**
		 * 商品列表
		 */
		@ApiField("items")
		private Items items;
		/**
		 * 承运商编码string (50) , SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通 、ZTO=中通 (ZTO) 、HTKY=百世汇通、BSKY=百世快运、UC=优速、STO=申通、TTKDEX=天天快递 、QFKD=全峰、FAST=快捷、POSTB=邮政小包 、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、AMAZON=亚马逊物流、DBWL=德邦物流、DBKD=德邦快递、DBKY=德邦快运、RRS=日日顺、OTHER=其他，必填, (只传英文编码)
		 */
		@ApiField("logisticsCode")
		private String logisticsCode;
		/**
		 * 物流公司名称, string (200)
		 */
		@ApiField("logisticsName")
		private String logisticsName;
		/**
		 * 备注, string (500) ,
		 */
		@ApiField("remarks")
		private String remarks;
		/**
		 * 当前状态操作时间, string (19) , YYYY-MM-DD HH:MM:SS
		 */
		@ApiField("signTime")
		private String signTime;
		/**
		 * 签收人姓名, string (50) ，必填
		 */
		@ApiField("signUserName")
		private String signUserName;
		/**
		 * 状态, sign-已签收string (50)
		 */
		@ApiField("status")
		private String status;
		/**
		 * 包裹重量 (千克) , double (18, 3)
		 */
		@ApiField("weight")
		private String weight;
	

	public String getExpressCode() {
			return this.expressCode;
		}
		public void setExpressCode(String expressCode) {
			this.expressCode = expressCode;
		}
		public Items getItems() {
			return this.items;
		}
		public void setItems(Items items) {
			this.items = items;
		}
		public String getLogisticsCode() {
			return this.logisticsCode;
		}
		public void setLogisticsCode(String logisticsCode) {
			this.logisticsCode = logisticsCode;
		}
		public String getLogisticsName() {
			return this.logisticsName;
		}
		public void setLogisticsName(String logisticsName) {
			this.logisticsName = logisticsName;
		}
		public String getRemarks() {
			return this.remarks;
		}
		public void setRemarks(String remarks) {
			this.remarks = remarks;
		}
		public String getSignTime() {
			return this.signTime;
		}
		public void setSignTime(String signTime) {
			this.signTime = signTime;
		}
		public String getSignUserName() {
			return this.signUserName;
		}
		public void setSignUserName(String signUserName) {
			this.signUserName = signUserName;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public String getWeight() {
			return this.weight;
		}
		public void setWeight(String weight) {
			this.weight = weight;
		}

}

	/**
 * 包裹列表
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Packages {

	/**
		 * 包裹详情
		 */
		@ApiField("packageValue")
		private Package packageValue;
	

	public Package getPackageValue() {
			return this.packageValue;
		}
		public void setPackageValue(Package packageValue) {
			this.packageValue = packageValue;
		}

}


}