package com.elitesland.yst.wms.connector.client.api.request;

import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;
import com.elitesland.yst.wms.connector.client.api.response.StockInCreateResponse;
import com.taobao.api.ApiRuleException;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.internal.mapping.ApiListType;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * TOP API: taobao.qimen.entryorder.create request
 *
 * @author top auto create
 * @since 1.0, 2024.01.09
 */
public class StockInCreateRequest extends YstWmsRequest<StockInCreateResponse> {


    /**
     * 入库单信息
     */
    private EntryOrder entryOrder;

    /**
     * 扩展属性
     */
    private Map extendProps;

    /**
     * 单据信息
     */
    private List<OrderLine> orderLines;

    public List<OrderLine> getOrderLines() {
        return orderLines;
    }

    public void setOrderLines(List<OrderLine> orderLines) {
        this.orderLines = orderLines;
    }

    public EntryOrder getEntryOrder() {
        return entryOrder;
    }

    public void setEntryOrder(EntryOrder entryOrder) {
        this.entryOrder = entryOrder;
    }

    public Map getExtendProps() {
        return extendProps;
    }

    public void setExtendProps(Map extendProps) {
        this.extendProps = extendProps;
    }


    public String getApiMethodName() {
        return "taobao.qimen.entryorder.create";
    }

    public Class<StockInCreateResponse> getResponseClass() {
        return StockInCreateResponse.class;
    }

    public void check() throws ApiRuleException {
    }

    @Data
    public static class EntryOrder {
        /**
         * 入库单号 必填
         */
        private String entryOrderCode;

        /**
         * 货主编码 必填
         */
        private String ownerCode;

        /**
         * 采购单号(当orderType=CGRK时使用) 采购入库时传入
         */
        private String purchaseOrderCode;

        /**
         * 入库仓库编码(统仓统配等无需ERP指定仓储编码的情况填OTHER) 必填
         */
        private String warehouseCode;

        /**
         * 关联的订单编号
         */
        private List<RelatedOrder> relatedOrders;

        /**
         * 订单创建时间(YYYY-MM-DD HH:MM:SS)
         */
        private String orderCreateTime;

        /**
         * 业务类型(SCRK=生产入库;LYRK=领用入库;CCRK=残次品入库;CGRK=采购入库;DBRK=调拨入库;QTRK=其他入库;B2BRK=B2B入 库;XNRK=虚拟入库;只传英文编码)
         */
        private String orderType;


        /**
         * 预期到货时间(YYYY-MM-DD HH:MM:SS)
         */
        private String expectStartTime;

        /**
         * 最迟预期到货时间(YYYY-MM-DD HH:MM:SS)
         */
        private String expectEndTime;

        /**
         * 物流公司编码(SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通 、ZTO=中通(ZTO)、HTKY=百世汇通、 UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、 AMAZON=亚马逊物流、OTHER=其他(只传英文编码))
         */
        private String logisticsCode;

        /**
         * 物流公司名称
         */
        private String logisticsName;

        /**
         * 运单号
         */
        private String expressCode;

        /**
         * 供应商编码
         */
        private String supplierCode;

        /**
         * 供应商名称
         */
        private String supplierName;

        /**
         * 操作员编码
         */
        private String operatorCode;

        /**
         * 操作员名称
         */
        private String operatorName;

        /**
         * 操作时间(YYYY-MM-DD HH:MM:SS)
         */
        private String operateTime;

        /**
         * 发件人信息
         */
        private AddressInfo senderInfo;

        /**
         * 收件人信息
         */
        private AddressInfo receiverInfo;

        /**
         * 备注
         */
        private String remark;

        /**
         * totalOrderLines
         */
        private String totalOrderLines;

        /**
         * 入库仓库名称
         */
        private String warehouseName;

        /**
         * 出库仓库编码
         */
        private String sourceWarehouseCode;

        /**
         * 出库仓库名称
         */
        private String sourceWarehouseName;

        /**
         * 入库单信息扩展属性
         */
        private Map extendProps;
    }

    @Data
    public static class RelatedOrder {

        /**
         * 关联的订单编号
         */
        @ApiField("orderCode")
        private String orderCode;

        /**
         * 关联的订单类型(CG=采购单;DB=调拨单;CK=出库单;RK=入库单;只传英文编码)
         */
        @ApiField("orderType")
        private String orderType;
    }

    /**
     * 地址信息
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class AddressInfo {

        /**
         * 区域
         */
        @ApiField("area")
        private String area;
        /**
         * 城市
         */
        @ApiField("city")
        private String city;
        /**
         * 公司名称
         */
        @ApiField("company")
        private String company;
        /**
         * 国家二字码
         */
        @ApiField("countryCode")
        private String countryCode;
        /**
         * 详细地址
         */
        @ApiField("detailAddress")
        private String detailAddress;
        /**
         * 电子邮箱
         */
        @ApiField("email")
        private String email;
        /**
         * 移动电话
         */
        @ApiField("mobile")
        private String mobile;
        /**
         * 姓名
         */
        @ApiField("name")
        private String name;
        /**
         * 省份
         */
        @ApiField("province")
        private String province;
        /**
         * 固定电话
         */
        @ApiField("tel")
        private String tel;
        /**
         * 村镇
         */
        @ApiField("town")
        private String town;
        /**
         * 邮编
         */
        @ApiField("zipCode")
        private String zipCode;

    }

    /**
     * 订单信息
     *
     * @author top auto create
     * @since 1.0, null
     */
    @ApiListType("orderLine")
    @Data
    public static class OrderLine {

        /**
         * 外部业务编码(消息ID;用于去重;当单据需要分批次发送时使用)
         */
        @ApiField("outBizCode")
        private String outBizCode;

        /**
         * 入库单的行号
         */
        @ApiField("orderLineNo")
        private String orderLineNo;

        /**
         * 货主编码 必填
         */
        @ApiField("ownerCode")
        private String ownerCode;

        /**
         * 商品编码 必填
         */
        @ApiField("itemCode")
        private String itemCode;

        /**
         * 仓储系统商品ID
         */
        @ApiField("itemId")
        private String itemId;

        /**
         * 商品名称
         */
        @ApiField("itemName")
        private String itemName;

        /**
         * 应收商品数量
         */
        @ApiField("planQty")
        private BigDecimal planQty;

        /**
         * 属性	商品属性
         */
        @ApiField("skuProperty")
        private String skuProperty;

        /**
         * 采购价
         */
        @ApiField("purchasePrice")
        private String purchasePrice;

        /**
         * 零售价
         */
        @ApiField("retailPrice")
        private String retailPrice;

        /**
         * 库存类型(ZP=正品;CC=残次;JS=机损;XS=箱损;默认为ZP)
         */
        @ApiField("inventoryType")
        private String inventoryType;

        /**
         * 商品生产日期(YYYY-MM-DD)
         */
        @ApiField("productDate")
        private String productDate;

        /**
         * 商品过期日期(YYYY-MM-DD)
         */
        @ApiField("expireDate")
        private String expireDate;

        /**
         * 单位
         */
        @ApiField("unit")
        private String unit;

        private Map extendProps;
    }

}