/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.feature;

import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.TaobaoResponse;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AutoRetryFeature {
    private static final Log log = LogFactory.getLog(AutoRetryFeature.class);
    private static final ApiException RETRY_FAIL = new ApiException("sdk.retry-call-fail", "API\u8c03\u7528\u91cd\u8bd5\u5931\u8d25");
    private int maxRetryCount = 3;
    private long retryWaitTime = 100L;
    private boolean throwIfOverMaxRetry = false;
    private Set<String> retryErrorCodes;

    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request, String session) throws ApiException {
        TaobaoResponse rsp = null;
        ApiException exp = null;
        for (int i = 0; i <= this.maxRetryCount; ++i) {
            if (i > 0) {
                if (!(rsp != null && (rsp.getSubCode() != null && rsp.getSubCode().startsWith("isp.") || this.retryErrorCodes != null && this.retryErrorCodes.contains(rsp.getSubCode()))) && exp == null) break;
                this.sleepWithoutInterrupt(this.retryWaitTime);
                log.warn((Object)this.buildRetryLog(request.getApiMethodName(), request.getTextParams(), i));
            }
            try {
                rsp = this.clientExecute(request, session);
                if (rsp.isSuccess()) {
                    return (T)rsp;
                }
                if (i != this.maxRetryCount || !this.throwIfOverMaxRetry) continue;
                throw RETRY_FAIL;
            }
            catch (ApiException e) {
                if (exp != null) continue;
                exp = e;
            }
        }
        if (exp != null) {
            throw exp;
        }
        return (T)rsp;
    }

    private String buildRetryLog(String apiName, Map<String, String> params, int retryCount) {
        StringBuilder sb = new StringBuilder();
        sb.append(apiName).append(" retry call ").append(retryCount);
        params.remove("fields");
        sb.append(" times, params=").append(params);
        return sb.toString();
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public void setRetryWaitTime(long retryWaitTime) {
        this.retryWaitTime = retryWaitTime;
    }

    public void setThrowIfOverMaxRetry(boolean throwIfOverMaxRetry) {
        this.throwIfOverMaxRetry = throwIfOverMaxRetry;
    }

    public void setRetryErrorCodes(Set<String> retryErrorCodes) {
        this.retryErrorCodes = retryErrorCodes;
    }

    private void sleepWithoutInterrupt(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public abstract <T extends TaobaoResponse> T clientExecute(TaobaoRequest<T> var1, String var2) throws ApiException;
}

