package com.elitesland.yst.wms.connector.client.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;

import com.elitesland.yst.wms.connector.client.api.response.InventoryReportResponse;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * TOP API: taobao.qimen.inventory.report request
 * 
 * @author top auto create
 * @since 1.0, 2024.01.24
 */
@Data
public class InventoryReportRequest extends YstWmsRequest<InventoryReportResponse> {

    @ApiModelProperty("外仓仓库编码")
    private String otherWhCode;        // 外仓仓库编码(物理仓编码)

    @ApiModelProperty("盘点单据编码")
    private String checkDocNo;         // 盘点单据编码

    @ApiModelProperty("公司编码")
    private String ouCode;             // 公司编码

    @ApiModelProperty("来源系统")
    private String sourceSystem;       // 来源系统

    @ApiModelProperty("来源单号")
    private String sourceDocNo;        // 来源单号

    @ApiModelProperty("盘点明细信息")
    private List<Details> details;           // 行项目详情

    @Data
    public static class Details {

        @ApiModelProperty("盘点单明细ID")
        private String checkDetailId;      // 盘点单明细ID

        @ApiModelProperty("公司编码")
        private String ouCode;             // 公司编码

        @ApiModelProperty("商品编码")
        private String itemCode;           // 商品编码

        @ApiModelProperty("商品名称")
        private String itemName;           // 商品名称

        @ApiModelProperty("盘前库存数量")
        private Double accQty;             // 盘前库存数量

        @ApiModelProperty("实盘数量")
        private Double factQty;            // 实盘数量

        @ApiModelProperty("盈亏数量")
        private Double diffQty;            // 盈亏数量

        @ApiModelProperty("失效日期")
        private String expireDate;         // 失效日期

        @ApiModelProperty("生产日期")
        private String manuDate;           // 生产日期

        @ApiModelProperty("库存状态")
        private String limit1;             // 库存状态

        @ApiModelProperty("批次")
        private String lotNo;              // 批次

        @ApiModelProperty("批次号")
        private String manuLotNo;          // 批次号

        @ApiModelProperty("入库日期")
        private String recvDate;           // 入库日期
    }


    public String getApiMethodName() {
		return "taobao.qimen.inventory.report";
	}

	public Class<InventoryReportResponse> getResponseClass() {
		return InventoryReportResponse.class;
	}

	


}