package com.elitesland.yst.wms.connector.client.api.request;

import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;
import com.elitesland.yst.wms.connector.client.api.response.ExamResultResponse;
import com.elitesland.yst.wms.connector.client.api.response.ReceiverResultResponse;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class ReceiverResultRequest extends YstWmsRequest<ReceiverResultResponse> {
    /**
     * 基本信息
     */
    @ApiModelProperty("到货通知单号")
    private String noticeNo;          // 到货通知单号

    @ApiModelProperty("WMS收货单号")
    private String wmsRecvNo;         // WMS收货单号

    @ApiModelProperty("货主编码")
    private String ouCode;            // 货主编码

    @ApiModelProperty("供应商编码")
    private String suppCode;          // 供应商编码

    @ApiModelProperty("采购单编码")
    private String relateDocNo;       // 采购单编码

    @ApiModelProperty("到货日期")
    private String demandDate;        // 到货日期

    @ApiModelProperty("预计到货日期")
    private String etaDate;           // 预计到货日期

    @ApiModelProperty("仓库编码")
    private String whCode;            // 仓库编码

    @ApiModelProperty("收货人")
    private String recvEmpName;       // 收货人

    @ApiModelProperty("是否越库")
    private String overStockFlag;     // 是否越库

    @ApiModelProperty("国家编码")
    private String country;           // 国家编码

    @ApiModelProperty("省编码")
    private String province;          // 省编码

    @ApiModelProperty("市编码")
    private String city;              // 市编码

    @ApiModelProperty("区编码")
    private String county;            // 区编码

    @ApiModelProperty("收货地址")
    private String recvAddr;          // 收货地址

    /**
     * 行项目详情
     */
    @ApiModelProperty("行项目详情")
    private List<Details> details;

    @Data
    public static class Details {

        @ApiModelProperty("商品编码")
        private String itemCode;        // 商品编码

        @ApiModelProperty("商品名称")
        private String itemName;        // 商品名称

        @ApiModelProperty("订购数量")
        private String poQty;           // 订购数量

        @ApiModelProperty("本次收货数量")
        private String ltstQty;         // 本次收货数量

        @ApiModelProperty("生产日期")
        private String manuDate;        // 生产日期

        @ApiModelProperty("有效期至")
        private String expiredDate;     // 有效期至

        @ApiModelProperty("批号")
        private String productNo;       // 批号

        @ApiModelProperty("生产厂家")
        private String manuFactory;     // 生产厂家

        @ApiModelProperty("规格型号")
        private String spec;            // 规格\型号

        @ApiModelProperty("浓度规格")
        private String concSpec;        // 浓度规格

        @ApiModelProperty("批准文号备案证号注册证号")
        private String approvalNumber;  // 批准文号\备案证号\注册证号
    }


    @Override
    public String getApiMethodName() {
        return null;
    }

    @Override
    public Class<ReceiverResultResponse> getResponseClass() {
        return ReceiverResultResponse.class;
    }


}