package com.elitesland.yst.wms.connector.client.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;

import com.elitesland.yst.wms.connector.client.api.response.WarehouseinfoQueryResponse;

/**
 * TOP API: taobao.qimen.warehouseinfo.query request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class WarehouseinfoQueryRequest extends YstWmsRequest<WarehouseinfoQueryResponse> {
	
	

	/** 
	* 扩展属性
	 */
	private Map extendProps;

	/** 
	* 奇门仓储字段
	 */
	private String ownerCode;

	public void setExtendProps(Map extendProps) {
		this.extendProps = extendProps;
	}

	public Map getExtendProps() {
		return this.extendProps;
	}

	public void setOwnerCode(String ownerCode) {
		this.ownerCode = ownerCode;
	}

	public String getOwnerCode() {
		return this.ownerCode;
	}

	public String getApiMethodName() {
		return "taobao.qimen.warehouseinfo.query";
	}

	public Class<WarehouseinfoQueryResponse> getResponseClass() {
		return WarehouseinfoQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMaxLength(ownerCode, 50, "ownerCode");
	}
	

}