package com.elitesland.yst.wms.connector.client.api.request;

import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;
import com.elitesland.yst.wms.connector.client.api.response.StockRtnInCreateResponse;
import com.taobao.api.ApiRuleException;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListType;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * TOP API: taobao.qimen.returnorder.create request
 *
 * @author top auto create
 * @since 1.0, 2024.01.09
 */
public class StockRtnInCreateRequest extends YstWmsRequest<StockRtnInCreateResponse> {

    /**
     * 入库单信息
     */
    private ReturnOrder returnOrder;

    /**
     * 扩展属性
     */
    private Map extendProps;

    /**
     * 单据信息
     */
    private List<OrderLine> orderLines;

    public List<OrderLine> getOrderLines() {
        return orderLines;
    }

    public void setOrderLines(List<OrderLine> orderLines) {
        this.orderLines = orderLines;
    }

    public Map getExtendProps() {
        return extendProps;
    }

    public void setExtendProps(Map extendProps) {
        this.extendProps = extendProps;
    }


    public String getApiMethodName() {
        return "taobao.qimen.returnorder.create";
    }

    public ReturnOrder getReturnOrder() {
        return returnOrder;
    }

    public void setReturnOrder(ReturnOrder returnOrder) {
        this.returnOrder = returnOrder;
    }


    public Class<StockRtnInCreateResponse> getResponseClass() {
        return StockRtnInCreateResponse.class;
    }

    public void check() throws ApiRuleException {
    }

    @Data
    public static class ReturnOrder {
        /**
         * ERP的退货入库单编码 必填
         */
        private String returnOrderCode;

        /**
         * 入库仓库编码(统仓统配等无需ERP指定仓储编码的情况填OTHER) 必填
         */
        private String warehouseCode;

        /**
         * 原出库单号(ERP分配) 必填
         */
        private String preDeliveryOrderCode;

        /**
         * 原出库单号(WMS分配)
         */
        private String preDeliveryOrderId;

        /**
         * 退货原因
         */
        private String returnReason;

        /**
         * 单据类型(THRK=退货入库;HHRK=换货入库;只传英文编码)
         */
        private String orderType;


        /**
         * 买家昵称
         */
        private String buyerNick;

        /**
         * 订单来源平台编码, string (50),TB= 淘宝 、TM=天猫 、JD=京东、DD=当当、PP=拍拍、YX=易讯、EBAY=ebay、QQ=QQ网购、AMAZON=亚马逊、SN=苏宁、GM=国美、WPH=唯品会、JM=聚美、LF=乐蜂、MGJ=蘑菇街、JS=聚尚、PX=拍鞋、YT=银泰、YHD=1号店、VANCL=凡客、YL=邮乐、YG=优购、1688=阿里巴巴、POS=POS门店、MIA=蜜芽、GW=商家官网、CT=村淘、YJWD=云集微店、PDD=拼多多、OTHERS=其他,
         */
        private String sourcePlatformCode;

        /**
         * 物流公司编码(SF=顺丰、EMS=标准快递、EYB=经济快件、ZJS=宅急送、YTO=圆通 、ZTO=中通(ZTO)、HTKY=百世汇通、 UC=优速、STO=申通、TTKDEX=天天快递、QFKD=全峰、FAST=快捷、POSTB=邮政小包、GTO=国通、YUNDA=韵达、JD=京东配送、DD=当当宅配、 AMAZON=亚马逊物流、OTHER=其他(只传英文编码))
         */
        private String logisticsCode;

        /**
         * 物流公司名称
         */
        private String logisticsName;

        /**
         * 运单号
         */
        private String expressCode;

        /**
         * 订单来源平台名称
         */
        private String sourcePlatformName;

        /**
         * 供应商名称
         */
        private String shopNick;

        /**
         * 操作员编码
         */
        private String sellerNick;

        /**
         * 发件人信息
         */
        private AddressInfo senderInfo;

        /**
         * 备注
         */
        private String remark;

        /**
         * 入库单信息扩展属性
         */
        private Map extendProps;
    }

    /**
     * 地址信息
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class AddressInfo {

        /**
         * 区域
         */
        @ApiField("area")
        private String area;
        /**
         * 城市
         */
        @ApiField("city")
        private String city;
        /**
         * 公司名称
         */
        @ApiField("company")
        private String company;
        /**
         * 国家二字码
         */
        @ApiField("countryCode")
        private String countryCode;
        /**
         * 详细地址
         */
        @ApiField("detailAddress")
        private String detailAddress;
        /**
         * 电子邮箱
         */
        @ApiField("email")
        private String email;
        /**
         * 移动电话
         */
        @ApiField("mobile")
        private String mobile;
        /**
         * 姓名
         */
        @ApiField("name")
        private String name;
        /**
         * 省份
         */
        @ApiField("province")
        private String province;
        /**
         * 固定电话
         */
        @ApiField("tel")
        private String tel;
        /**
         * 村镇
         */
        @ApiField("town")
        private String town;
        /**
         * 邮编
         */
        @ApiField("zipCode")
        private String zipCode;

    }

    /**
     * 订单信息
     *
     * @author top auto create
     * @since 1.0, null
     */
    @ApiListType("orderLine")
    @Data
    public static class OrderLine {

        /**
         * 单据行号
         */
        @ApiField("orderLineNo")
        private String orderLineNo;

        /**
         * 交易平台订单
         */
        @ApiField("sourceOrderCode")
        private String sourceOrderCode;

        /**
         * 交易平台子订单编码
         */
        @ApiField("subSourceOrderCode")
        private String subSourceOrderCode;

        /**
         * 货主编码 必填
         */
        @ApiField("ownerCode")
        private String ownerCode;

        /**
         * 商品编码 必填
         */
        @ApiField("itemCode")
        private String itemCode;

        /**
         * 仓储系统商品ID
         */
        @ApiField("itemId")
        private String itemId;

        /**
         * 库存类型(ZP=正品;CC=残次;JS=机损;XS=箱损;默认为ZP)
         */
        @ApiField("inventoryType")
        private String inventoryType;

        /**
         * 应收商品数量
         */
        @ApiField("planQty")
        private BigDecimal planQty;

        /**
         * 批次编码
         */
        @ApiField("batchCode")
        private String batchCode;

        /**
         * 生产日期(YYYY-MM-DD)
         */
        @ApiField("productDate")
        private String productDate;

        /**
         * 过期日期(YYYY-MM-DD)
         */
        @ApiField("expireDate")
        private String expireDate;

        /**
         * 生产批号
         */
        @ApiField("produceCode")
        private String produceCode;

        /**
         * 退货原因
         */
        @ApiField("returnReason")
        private String returnReason;

        /**
         * 用字符串格式来表示订单标记列表(比如VISIT^ SELLER_AFFORD^SYNC_RETURN_BILL等;中间用“^”来隔开订单标记list (所 有字母全部大写) VISIT=上门；SELLER_AFFORD=是否卖家承担运费(默认是)SYNC_RETURN_BILL=同时退回发票)
         */
        @ApiField("orderFlag")
        private String orderFlag;

        private Map extendProps;
    }

}