package com.elitesland.yst.wms.connector.client.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;

import com.elitesland.yst.wms.connector.client.api.YstWmsResponse;

/**
 * TOP API: taobao.qimen.stockout.query response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class StockoutQueryResponse extends YstWmsResponse {

	private static final long serialVersionUID = 1735649676325297847L;

	/** 
	 * 出库单信息
	 */
	@ApiField("deliveryOrder")
	private DeliveryOrder deliveryOrder;

	/** 
	 * 单据信息列表
	 */
	@ApiListField("orderLines")
	@ApiField("orderLine")
	private List<OrderLine> orderLines;

	/** 
	 * 包裹信息
	 */
	@ApiListField("packages")
	@ApiField("package")
	private List<Package> packages;

	/** 
	 * orderLines总条数
	 */
	@ApiField("totalLines")
	private Long totalLines;


	public void setDeliveryOrder(DeliveryOrder deliveryOrder) {
		this.deliveryOrder = deliveryOrder;
	}
	public DeliveryOrder getDeliveryOrder( ) {
		return this.deliveryOrder;
	}

	public void setOrderLines(List<OrderLine> orderLines) {
		this.orderLines = orderLines;
	}
	public List<OrderLine> getOrderLines( ) {
		return this.orderLines;
	}

	public void setPackages(List<Package> packages) {
		this.packages = packages;
	}
	public List<Package> getPackages( ) {
		return this.packages;
	}

	public void setTotalLines(Long totalLines) {
		this.totalLines = totalLines;
	}
	public Long getTotalLines( ) {
		return this.totalLines;
	}
	
	/**
 * 出库单信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class DeliveryOrder {

	/**
		 * 出库单号
		 */
		@ApiField("deliveryOrderCode")
		private String deliveryOrderCode;
		/**
		 * 仓储系统出库单号
		 */
		@ApiField("deliveryOrderId")
		private String deliveryOrderId;
		/**
		 * 运单号
		 */
		@ApiField("expressCode")
		private String expressCode;
		/**
		 * 物流公司编码
		 */
		@ApiField("logisticsCode")
		private String logisticsCode;
		/**
		 * 物流公司名称
		 */
		@ApiField("logisticsName")
		private String logisticsName;
		/**
		 * 订单完成时间
		 */
		@ApiField("orderConfirmTime")
		private String orderConfirmTime;
		/**
		 * 出库单类型
		 */
		@ApiField("orderType")
		private String orderType;
		/**
		 * 出库单状态
		 */
		@ApiField("status")
		private String status;
		/**
		 * 仓库编码
		 */
		@ApiField("warehouseCode")
		private String warehouseCode;
	

	public String getDeliveryOrderCode() {
			return this.deliveryOrderCode;
		}
		public void setDeliveryOrderCode(String deliveryOrderCode) {
			this.deliveryOrderCode = deliveryOrderCode;
		}
		public String getDeliveryOrderId() {
			return this.deliveryOrderId;
		}
		public void setDeliveryOrderId(String deliveryOrderId) {
			this.deliveryOrderId = deliveryOrderId;
		}
		public String getExpressCode() {
			return this.expressCode;
		}
		public void setExpressCode(String expressCode) {
			this.expressCode = expressCode;
		}
		public String getLogisticsCode() {
			return this.logisticsCode;
		}
		public void setLogisticsCode(String logisticsCode) {
			this.logisticsCode = logisticsCode;
		}
		public String getLogisticsName() {
			return this.logisticsName;
		}
		public void setLogisticsName(String logisticsName) {
			this.logisticsName = logisticsName;
		}
		public String getOrderConfirmTime() {
			return this.orderConfirmTime;
		}
		public void setOrderConfirmTime(String orderConfirmTime) {
			this.orderConfirmTime = orderConfirmTime;
		}
		public String getOrderType() {
			return this.orderType;
		}
		public void setOrderType(String orderType) {
			this.orderType = orderType;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public String getWarehouseCode() {
			return this.warehouseCode;
		}
		public void setWarehouseCode(String warehouseCode) {
			this.warehouseCode = warehouseCode;
		}

}

	/**
 * 包材信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class PackageMaterial {

	/**
		 * 包材的数量
		 */
		@ApiField("quantity")
		private Long quantity;
		/**
		 * 包材型号
		 */
		@ApiField("type")
		private String type;
	

	public Long getQuantity() {
			return this.quantity;
		}
		public void setQuantity(Long quantity) {
			this.quantity = quantity;
		}
		public String getType() {
			return this.type;
		}
		public void setType(String type) {
			this.type = type;
		}

}

	/**
 * 商品信息列表
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Item {

	/**
		 * 商品编码
		 */
		@ApiField("itemCode")
		private String itemCode;
		/**
		 * 商品仓储系统编码
		 */
		@ApiField("itemId")
		private String itemId;
		/**
		 * 包裹内该商品的数量
		 */
		@ApiField("quantity")
		private Long quantity;
	

	public String getItemCode() {
			return this.itemCode;
		}
		public void setItemCode(String itemCode) {
			this.itemCode = itemCode;
		}
		public String getItemId() {
			return this.itemId;
		}
		public void setItemId(String itemId) {
			this.itemId = itemId;
		}
		public Long getQuantity() {
			return this.quantity;
		}
		public void setQuantity(Long quantity) {
			this.quantity = quantity;
		}

}

	/**
 * 包裹信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Package {

	/**
		 * 运单号
		 */
		@ApiField("expressCode")
		private String expressCode;
		/**
		 * 包裹高度(厘米)
		 */
		@ApiField("height")
		private String height;
		/**
		 * 商品信息列表
		 */
		@ApiListField("items")
		@ApiField("item")
		private List<Item> items;
		/**
		 * 包裹长度(厘米)
		 */
		@ApiField("length")
		private String length;
		/**
		 * 物流公司名称
		 */
		@ApiField("logisticsName")
		private String logisticsName;
		/**
		 * 包裹编号
		 */
		@ApiField("packageCode")
		private String packageCode;
		/**
		 * 包材信息
		 */
		@ApiListField("packageMaterialList")
		@ApiField("packageMaterial")
		private List<PackageMaterial> packageMaterialList;
		/**
		 * 包裹体积(升L)
		 */
		@ApiField("volume")
		private String volume;
		/**
		 * 包裹重量(千克)
		 */
		@ApiField("weight")
		private String weight;
		/**
		 * 包裹宽度(厘米)
		 */
		@ApiField("width")
		private String width;
	

	public String getExpressCode() {
			return this.expressCode;
		}
		public void setExpressCode(String expressCode) {
			this.expressCode = expressCode;
		}
		public String getHeight() {
			return this.height;
		}
		public void setHeight(String height) {
			this.height = height;
		}
		public List<Item> getItems() {
			return this.items;
		}
		public void setItems(List<Item> items) {
			this.items = items;
		}
		public String getLength() {
			return this.length;
		}
		public void setLength(String length) {
			this.length = length;
		}
		public String getLogisticsName() {
			return this.logisticsName;
		}
		public void setLogisticsName(String logisticsName) {
			this.logisticsName = logisticsName;
		}
		public String getPackageCode() {
			return this.packageCode;
		}
		public void setPackageCode(String packageCode) {
			this.packageCode = packageCode;
		}
		public List<PackageMaterial> getPackageMaterialList() {
			return this.packageMaterialList;
		}
		public void setPackageMaterialList(List<PackageMaterial> packageMaterialList) {
			this.packageMaterialList = packageMaterialList;
		}
		public String getVolume() {
			return this.volume;
		}
		public void setVolume(String volume) {
			this.volume = volume;
		}
		public String getWeight() {
			return this.weight;
		}
		public void setWeight(String weight) {
			this.weight = weight;
		}
		public String getWidth() {
			return this.width;
		}
		public void setWidth(String width) {
			this.width = width;
		}

}

	/**
 * 单据信息列表
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class OrderLine {

	/**
		 * 实发商品数量
		 */
		@ApiField("actualQty")
		private Long actualQty;
		/**
		 * 批次编号
		 */
		@ApiField("batchCode")
		private String batchCode;
		/**
		 * 过期日期(YYYY-MM-DD)
		 */
		@ApiField("expireDate")
		private String expireDate;
		/**
		 * 库存类型
		 */
		@ApiField("inventoryType")
		private String inventoryType;
		/**
		 * 商品编码
		 */
		@ApiField("itemCode")
		private String itemCode;
		/**
		 * 商品仓储系统编码
		 */
		@ApiField("itemId")
		private String itemId;
		/**
		 * 商品名称
		 */
		@ApiField("itemName")
		private String itemName;
		/**
		 * 单据行号
		 */
		@ApiField("orderLineNo")
		private String orderLineNo;
		/**
		 * 生产批号
		 */
		@ApiField("produceCode")
		private String produceCode;
		/**
		 * 生产日期(YYYY-MM-DD)
		 */
		@ApiField("productDate")
		private String productDate;
	

	public Long getActualQty() {
			return this.actualQty;
		}
		public void setActualQty(Long actualQty) {
			this.actualQty = actualQty;
		}
		public String getBatchCode() {
			return this.batchCode;
		}
		public void setBatchCode(String batchCode) {
			this.batchCode = batchCode;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getInventoryType() {
			return this.inventoryType;
		}
		public void setInventoryType(String inventoryType) {
			this.inventoryType = inventoryType;
		}
		public String getItemCode() {
			return this.itemCode;
		}
		public void setItemCode(String itemCode) {
			this.itemCode = itemCode;
		}
		public String getItemId() {
			return this.itemId;
		}
		public void setItemId(String itemId) {
			this.itemId = itemId;
		}
		public String getItemName() {
			return this.itemName;
		}
		public void setItemName(String itemName) {
			this.itemName = itemName;
		}
		public String getOrderLineNo() {
			return this.orderLineNo;
		}
		public void setOrderLineNo(String orderLineNo) {
			this.orderLineNo = orderLineNo;
		}
		public String getProduceCode() {
			return this.produceCode;
		}
		public void setProduceCode(String produceCode) {
			this.produceCode = produceCode;
		}
		public String getProductDate() {
			return this.productDate;
		}
		public void setProductDate(String productDate) {
			this.productDate = productDate;
		}

}



}
