package com.elitesland.yst.wms.connector.config;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @author : chen.niu
 * @description :
 * @date : 2025-04-01 14:16
 */
@Data
public class YstWmsRequestClientConfig {
    // 请求方系统编码
    private String sourceSysCode;
    // 请求方应用编码
    private String sourceAppCode;
    // 请求方应用密钥
    private String sourceAppSecret;

    // wms系统编码
    private String wmsSysCode;
    // wms应用编码
    private String wmsAppKey;
    // wms应用密钥
    private String wmsAppSecret;
    // 接口平台服务器URL
    private String serverBaseUrl;
//    // 云时通租户编码 用于日志记录事租户隔离
//    private String ystSysTenantCode;

    public void validateConfig() {
        if (StringUtils.isBlank(sourceSysCode)) {
            throw new IllegalArgumentException("sourceSysCode 不能为null或空");
        }
        if (StringUtils.isBlank(sourceAppCode)) {
            throw new IllegalArgumentException("sourceAppCode 不能为null或空");
        }
        if (StringUtils.isBlank(sourceAppSecret)) {
            throw new IllegalArgumentException("sourceAppSecret 不能为null或空");
        }
        if (StringUtils.isBlank(wmsSysCode)) {
            throw new IllegalArgumentException("wmsSysCode 不能为null或空");
        }
//        if (StringUtils.isBlank(wmsAppKey)) {
//            throw new IllegalArgumentException("wmsAppKey cannot be null or empty");
//        }
//        if (StringUtils.isBlank(wmsAppSecret)) {
//            throw new IllegalArgumentException("wmsAppSecret cannot be null or empty");
//        }
        if (StringUtils.isBlank(serverBaseUrl)) {
            throw new IllegalArgumentException("serverBaseUrl 不能为null或空");
        }
//        if (StringUtils.isBlank(ystSysTenantCode)) {
//            throw new IllegalArgumentException("ystSysTenantCode cannot be null or empty");
//        }
    }
}
