package com.elitesland.yst.wms.connector.constant;

import com.elitescloud.cloudt.system.vo.DprUdcVO;
import lombok.Getter;

import java.util.List;

/**
 * @author : chen.niu
 * @description : WMS调用类型
 * @date : 2025-04-01 15:03
 */
public enum WmsConnectorRouterCallType implements BasicWmsUdcEnumInterface {


    WMS_CALL_API("直连正向主调",1),
    INTERIOR_CALL_JOB("内部JOB正向主调",2),
    WMS_CALL_BACK_API("WMS指令反向回调",3),
    ;
    @Getter
    private String description;

    private final DprUdcVO udcVO;

    WmsConnectorRouterCallType(String description, int sortNo) {
        this.description = description;
        this.udcVO = newUdcVo("YST-WMSC", "WmsCallType", "WMS调用类型", description, sortNo, name());
    }

    @Override
    public DprUdcVO getUdcVO() {
        return udcVO;
    }

    @Override
    public String getValueDescription() {
        return udcVO.getValDesc();
    }

    // 静态方法通过接口工具类实现
    public static List<DprUdcVO> getAllUdc() {
        return BasicWmsUdcEnumInterface.getUdcList(WmsConnectorRouterCallType.class);
    }

    public static String getDescription(String key) {
        return BasicWmsUdcEnumInterface.getDescription(WmsConnectorRouterCallType.class, key);
    }


}
