package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CainiaoEndpointLockerTopWithholdQueryResponse;

/**
 * TOP API: cainiao.endpoint.locker.top.withhold.query request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.19
 */
public class CainiaoEndpointLockerTopWithholdQueryRequest extends BaseTaobaoRequest<CainiaoEndpointLockerTopWithholdQueryResponse> {
	
	

	/** 
	* 柜子公司编码
	 */
	private String companyCode;

	/** 
	* 开放用户Id
	 */
	private String openUserId;

	/** 
	* 柜子业务：0-取件业务，1-寄件业务，2-派样业务，3-小件员约柜（在约期内仅能使用一次）4-小件员租柜（在约期内可反复使用）
	 */
	private Long orderType;

	public void setCompanyCode(String companyCode) {
		this.companyCode = companyCode;
	}

	public String getCompanyCode() {
		return this.companyCode;
	}

	public void setOpenUserId(String openUserId) {
		this.openUserId = openUserId;
	}

	public String getOpenUserId() {
		return this.openUserId;
	}

	public void setOrderType(Long orderType) {
		this.orderType = orderType;
	}

	public Long getOrderType() {
		return this.orderType;
	}

	public String getApiMethodName() {
		return "cainiao.endpoint.locker.top.withhold.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("company_code", this.companyCode);
		txtParams.put("open_user_id", this.openUserId);
		txtParams.put("order_type", this.orderType);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CainiaoEndpointLockerTopWithholdQueryResponse> getResponseClass() {
		return CainiaoEndpointLockerTopWithholdQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(companyCode, "companyCode");
		RequestCheckUtils.checkNotEmpty(openUserId, "openUserId");
		RequestCheckUtils.checkNotEmpty(orderType, "orderType");
	}
	

}