/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api;

import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.TaobaoResponse;
import com.taobao.api.internal.feature.BatchFeature;

public class BatchTaobaoClient
extends DefaultTaobaoClient {
    private BatchFeature feature;

    private void initFeature(String serverUrl, DefaultTaobaoClient client) {
        this.feature = new BatchFeature(){

            @Override
            public <T extends TaobaoResponse> T clientExecute(TaobaoRequest<T> request, String session) throws ApiException {
                return (T)BatchTaobaoClient.super.execute(request, session);
            }
        };
        this.feature.init(serverUrl, client);
    }

    public BatchTaobaoClient(String serverUrl, String appKey, String appSecret) {
        super(BatchTaobaoClient.buildApiServerUrl(serverUrl), appKey, appSecret);
        this.initFeature(serverUrl, this);
    }

    public BatchTaobaoClient(String serverUrl, String appKey, String appSecret, String format) {
        super(BatchTaobaoClient.buildApiServerUrl(serverUrl), appKey, appSecret, format);
        this.initFeature(serverUrl, this);
    }

    public BatchTaobaoClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout) {
        super(BatchTaobaoClient.buildApiServerUrl(serverUrl), appKey, appSecret, format, connectTimeout, readTimeout);
        this.initFeature(serverUrl, this);
    }

    public BatchTaobaoClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout, String signMethod) {
        super(BatchTaobaoClient.buildApiServerUrl(serverUrl), appKey, appSecret, format, connectTimeout, readTimeout, signMethod);
        this.initFeature(serverUrl, this);
    }

    @Override
    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request, String session) throws ApiException {
        return this.feature.execute(request, session);
    }

    public void setBatchApiSeparator(String batchApiSeparator) {
        this.feature.setBatchApiSeparator(batchApiSeparator);
    }

    private static String buildApiServerUrl(String batchServerUrl) {
        if (batchServerUrl.contains("/router/batch")) {
            return batchServerUrl.replace("/router/batch", "/router/rest");
        }
        return batchServerUrl;
    }
}

