/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.remoting;

import com.taobao.api.internal.toplink.BufferManager;
import com.taobao.api.internal.toplink.DefaultLoggerFactory;
import com.taobao.api.internal.toplink.Logger;
import com.taobao.api.internal.toplink.LoggerFactory;
import com.taobao.api.internal.toplink.channel.ChannelContext;
import com.taobao.api.internal.toplink.channel.ChannelException;
import com.taobao.api.internal.toplink.channel.ChannelSender;
import com.taobao.api.internal.toplink.channel.SimpleChannelHandler;
import com.taobao.api.internal.toplink.protocol.NotSupportedException;
import com.taobao.api.internal.toplink.remoting.DefaultSerializationFactory;
import com.taobao.api.internal.toplink.remoting.FormatterException;
import com.taobao.api.internal.toplink.remoting.MethodCall;
import com.taobao.api.internal.toplink.remoting.MethodCallContext;
import com.taobao.api.internal.toplink.remoting.MethodReturn;
import com.taobao.api.internal.toplink.remoting.SerializationFactory;
import com.taobao.api.internal.toplink.remoting.Serializer;
import com.taobao.api.internal.toplink.remoting.protocol.RemotingTcpProtocolHandle;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;

public abstract class RemotingServerChannelHandler
extends SimpleChannelHandler {
    protected Logger logger;
    private ExecutorService threadPool;
    private SerializationFactory serializationFactory = new DefaultSerializationFactory();

    public RemotingServerChannelHandler() {
        this(DefaultLoggerFactory.getDefault());
    }

    public RemotingServerChannelHandler(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = loggerFactory.create(this);
    }

    public void setSerializationFactory(SerializationFactory serializationFactory) {
        this.serializationFactory = serializationFactory;
    }

    public abstract MethodReturn onMethodCall(MethodCall var1, MethodCallContext var2) throws Throwable;

    @Override
    public final void onMessage(ChannelContext context) throws ChannelException, NotSupportedException {
        Object msg = context.getMessage();
        if (msg instanceof ByteBuffer || msg instanceof RemotingTcpProtocolHandle) {
            this.onMessage(context, msg);
            return;
        }
        if (msg instanceof List) {
            for (Object buffer : (List)msg) {
                this.onMessage(context, buffer);
            }
            return;
        }
    }

    private void onMessage(final ChannelContext context, Object msg) throws ChannelException, NotSupportedException {
        final RemotingTcpProtocolHandle protocol = msg instanceof ByteBuffer ? new RemotingTcpProtocolHandle((ByteBuffer)msg) : (RemotingTcpProtocolHandle)msg;
        protocol.ReadPreamble();
        protocol.ReadMajorVersion();
        protocol.ReadMinorVersion();
        final short operation = protocol.ReadOperation();
        protocol.ReadContentDelimiter();
        protocol.ReadContentLength();
        final HashMap<String, Object> transportHeaders = protocol.ReadTransportHeaders();
        final MethodCallContext callContext = this.createCallContext(context, transportHeaders);
        final Serializer serializer = this.serializationFactory.get(transportHeaders.get("Format"));
        Object flag = transportHeaders.get("Flag");
        transportHeaders.clear();
        transportHeaders.put("Flag", flag);
        if (this.threadPool == null) {
            this.internalOnMessage(context, callContext, protocol, operation, transportHeaders, serializer);
            return;
        }
        try {
            this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        RemotingServerChannelHandler.this.internalOnMessage(context, callContext, protocol, operation, transportHeaders, serializer);
                    }
                    catch (ChannelException e) {
                        RemotingServerChannelHandler.this.logger.error(e);
                    }
                }
            });
        }
        catch (RejectedExecutionException exception) {
            String statusPhrase = String.format("server threadpool full, threadpool maxsize is: %s", ((ThreadPoolExecutor)this.threadPool).getMaximumPoolSize());
            this.logger.fatal(statusPhrase);
            transportHeaders.put("StatusCode", 500);
            transportHeaders.put("StatusPhrase", statusPhrase);
            this.reply(context, transportHeaders, null);
        }
    }

    private void internalOnMessage(ChannelContext context, MethodCallContext callContext, RemotingTcpProtocolHandle protocol, short operation, HashMap<String, Object> transportHeaders, Serializer serializer) throws ChannelException {
        MethodCall methodCall = null;
        MethodReturn methodReturn = null;
        try {
            methodCall = serializer.deserializeMethodCall(protocol.ReadContent());
            methodReturn = this.onMethodCall(methodCall, callContext);
        }
        catch (Throwable e) {
            this.logger.error(e);
            methodReturn = new MethodReturn();
            methodReturn.Exception = e;
        }
        if (operation == 1) {
            return;
        }
        byte[] data = null;
        try {
            data = serializer.serializeMethodReturn(methodReturn);
        }
        catch (FormatterException e) {
            this.logger.error(e);
            transportHeaders.put("StatusCode", 400);
            transportHeaders.put("StatusPhrase", e.getMessage());
        }
        this.reply(context, transportHeaders, data);
    }

    private void reply(ChannelContext context, HashMap<String, Object> transportHeaders, byte[] data) throws ChannelException {
        final ByteBuffer responseBuffer = BufferManager.getBuffer();
        RemotingTcpProtocolHandle handle = new RemotingTcpProtocolHandle(responseBuffer);
        handle.WritePreamble();
        handle.WriteMajorVersion();
        handle.WriteMinorVersion();
        handle.WriteOperation((short)2);
        handle.WriteContentDelimiter((short)0);
        handle.WriteContentLength(data != null ? data.length : 0);
        handle.WriteTransportHeaders(transportHeaders);
        if (data != null) {
            handle.WriteContent(data);
        }
        responseBuffer.flip();
        context.reply(responseBuffer, new ChannelSender.SendHandler(){

            @Override
            public void onSendComplete(boolean success) {
                BufferManager.returnBuffer(responseBuffer);
            }
        });
    }

    private MethodCallContext createCallContext(ChannelContext channelContext, Map<String, Object> headers) {
        MethodCallContext callContext = new MethodCallContext(channelContext.getSender());
        for (Map.Entry<String, Object> h : headers.entrySet()) {
            callContext.setCallContext(h.getKey(), h.getValue());
        }
        return callContext;
    }
}

