package com.elitesland.yst.wms.connector.client.api.request;

import io.swagger.annotations.ApiModelProperty;
import com.taobao.api.ApiRuleException;
import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;

import com.elitesland.yst.wms.connector.client.api.response.InventorySynchronizeResponse;
import lombok.Data;

/**
 * TOP API: taobao.qimen.inventory.synchronize request
 *
 * @author top auto create
 * @since 1.0, 2023.04.21
 */
@Data
public class InventorySynchronizeRequest extends YstWmsRequest<InventorySynchronizeResponse> {
	
	

    /**
     * 调整单编码,调整单编码,string(50),,
     */
    @ApiModelProperty("调整单编码,调整单编码,string(50),,")
    private String adjustOrderCode;

    /**
     * 订单创建时间,订单创建时间,string(50),,
     */
    @ApiModelProperty("订单创建时间,订单创建时间,string(50),,")
    private String adjustTime;

    /**
     * 库存调整类型,库存调整类型,string(50),,
     */
    @ApiModelProperty("库存调整类型,库存调整类型,string(50),,")
    private String adjustType;

    /**
     * 商品列表
     */
    @ApiModelProperty("商品列表")
    private Items items;

    /**
     * 货主编码,货主编码,string(50),,
     */
    @ApiModelProperty("货主编码,货主编码,string(50),,")
    private String ownerCode;

    /**
     * 关联订单
     */
    @ApiModelProperty("关联订单")
    private RelatedOrders relatedOrders;

    /**
     * 备注,备注,string(50),,
     */
    @ApiModelProperty("备注,备注,string(50),,")
    private String remark;

    /**
     * 仓库编码,仓库编码,string(50),,
     */
    @ApiModelProperty("仓库编码,仓库编码,string(50),,")
    private String warehouseCode;

    public String getApiMethodName() {
        return "taobao.qimen.inventory.synchronize";
    }

    public Class<InventorySynchronizeResponse> getResponseClass() {
        return InventorySynchronizeResponse.class;
    }

    public void check() throws ApiRuleException {
    }

    /**
     * 关联订单
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class RelatedOrders {

        /**
         * 关联的订单编号,关联的订单编号,string(50),,
         */
        @ApiModelProperty("关联的订单编号,关联的订单编号,string(50),,")
        private String orderCode;

        /**
         * 关联的订单类型,关联的订单类型,string(50),,
         */
        @ApiModelProperty("关联的订单类型,关联的订单类型,string(50),,")
        private String orderType;
    }

    /**
     * 商品
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class Item {

        /**
         * 批次编码,,string(50),,
         */
        @ApiModelProperty("批次编码,,string(50),,")
        private String batchCode;

        /**
         * 商品过期日期,,string(50),,
         */
        @ApiModelProperty("商品过期日期,,string(50),,")
        private String expireDate;

        /**
         * 库存类型,,string(50),,
         */
        @ApiModelProperty("库存类型,,string(50),,")
        private String inventoryType;

        /**
         * 商品编码,,string(50),,
         */
        @ApiModelProperty("商品编码,,string(50),,")
        private String itemCode;

        /**
         * 仓储系统商品ID,,string(50),,
         */
        @ApiModelProperty("仓储系统商品ID,,string(50),,")
        private String itemId;

        /**
         * 调整数量,,string(50),,
         */
        @ApiModelProperty("调整数量,,string(50),,")
        private String planQty;

        /**
         * 生产批号,,string(50),,
         */
        @ApiModelProperty("生产批号,,string(50),,")
        private String produceCode;

        /**
         * 商品生产日期,,string(50),,
         */
        @ApiModelProperty("商品生产日期,,string(50),,")
        private String productDate;

        /**
         * 备注,,string(50),,
         */
        @ApiModelProperty("备注,,string(50),,")
        private String remark;

        /**
         * 商品序列号,,string(50),,
         */
        @ApiModelProperty("商品序列号,,string(50),,")
        private String snCode;
    }

    /**
     * 商品列表
     *
     * @author top auto create
     * @since 1.0, null
     */
    @Data
    public static class Items {

        /**
         * 商品
         */
        @ApiModelProperty("商品")
        private Item item;
    }
}
