package com.elitesland.yst.wms.connector.constant.yst.enums;

/**
 * @author : chen.niu
 * @description : WMS同步状态枚举
 * @date : 2025-03-31 10:04
 */
public enum YstExternalSyncStatusEnum {
    RE("已撤回"),
    PI("推送中"),
    NPR("无需推送"),
    W("未推送"),
    S("成功"),
    R("等待重试"),
    E("失败");

    private final String description;


    YstExternalSyncStatusEnum(String description ) {
        this.description = description;

    }

    public String getDescription() {
        return description;
    }



    @Override
    public String toString() {
        return this.name() + " (" + description + ")";
    }
}
