/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.channel.tcp;

import com.taobao.api.internal.toplink.channel.ChannelException;
import com.taobao.api.internal.toplink.channel.ChannelSender;
import com.taobao.api.internal.toplink.channel.netty.NettyChannelSender;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;

public abstract class TcpChannelSender
extends NettyChannelSender {
    public TcpChannelSender(Channel channel) {
        super(channel);
    }

    @Override
    public void send(byte[] data, int offset, int length) throws ChannelException {
        this.send(ChannelBuffers.wrappedBuffer((byte[])data, (int)offset, (int)length), null);
    }

    @Override
    public void send(ByteBuffer dataBuffer, ChannelSender.SendHandler sendHandler) throws ChannelException {
        this.send(ChannelBuffers.wrappedBuffer((ByteBuffer)dataBuffer), sendHandler);
    }

    @Override
    public void close(String reason) {
        this.channel.write((Object)reason).addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                future.getChannel().close();
            }
        });
    }

    private void send(Object message, final ChannelSender.SendHandler sendHandler) throws ChannelException {
        if (sendHandler == null) {
            this.channel.write(message);
        } else {
            this.channel.write(message).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (sendHandler != null) {
                        sendHandler.onSendComplete(future.isSuccess());
                    }
                }
            });
        }
    }
}

