/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.frame.draft76;

import com.taobao.api.internal.toplink.embedded.websocket.frame.FrameHeader;
import com.taobao.api.internal.toplink.embedded.websocket.frame.draft76.FrameDraft76;
import com.taobao.api.internal.toplink.embedded.websocket.frame.draft76.FrameHeaderDraft76;
import java.nio.ByteBuffer;

public class CloseFrame
extends FrameDraft76 {
    protected CloseFrame() {
        FrameHeaderDraft76 header = new FrameHeaderDraft76(-1, 1L);
        this.setHeader(header);
        this.setContents(new byte[]{0});
    }

    protected CloseFrame(FrameHeader header, byte[] bodyData) {
        super(header, bodyData);
    }

    @Override
    public ByteBuffer toByteBuffer() {
        byte[] bodyLengthBuf = CloseFrame.getBodyLength(this.contents);
        ByteBuffer buf = ByteBuffer.allocate(1 + bodyLengthBuf.length + this.contents.length);
        buf.put(this.header.toByteBuffer());
        buf.put(bodyLengthBuf);
        buf.put(this.contents);
        buf.flip();
        return buf;
    }

    private static byte[] getBodyLength(byte[] body) {
        byte[] tmp = new byte[body.length / 7 + 1];
        int length = body.length;
        int i = 0;
        while (length != 0) {
            tmp[i] = (byte)(length | 0x7F | 0x80);
            length >>= 7;
            ++i;
        }
        tmp[--i] = (byte)(tmp[i] | 0x7F);
        byte[] bodyLengthBuf = new byte[i];
        System.arraycopy(tmp, 0, bodyLengthBuf, 0, bodyLengthBuf.length);
        return bodyLengthBuf;
    }
}

