/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.cluster;

import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoClient;
import com.taobao.api.internal.cluster.DnsConfig;
import com.taobao.api.internal.cluster.HttpdnsGetRequest;
import com.taobao.api.internal.cluster.HttpdnsGetResponse;
import com.taobao.api.internal.cluster.Weightable;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClusterManager {
    private static final Log log = LogFactory.getLog(ClusterManager.class);
    private static final Random random = new Random();
    private static final Object initLock = new Object();
    private static volatile DnsConfig dnsConfig = null;
    private static volatile Thread refreshThread = null;
    private static String defaultServerUrl = "http://gw.api.taobao.com/top/router/rest";
    private static Set<String> terminationCodeSet = new HashSet<String>();

    public static <T extends Weightable> T getElementByWeight(List<T> list) {
        Weightable selected = null;
        double totalWeight = 0.0;
        for (Weightable element : list) {
            double r = random.nextDouble() * (element.getWeight() + totalWeight);
            if (r >= totalWeight) {
                selected = element;
            }
            totalWeight += element.getWeight();
        }
        return (T)selected;
    }

    public static DnsConfig GetDnsConfigFromCache() {
        return dnsConfig;
    }

    public static void initRefreshThread(String appkey, String appSecret) {
        ClusterManager.initRefreshThread(new DefaultTaobaoClient(defaultServerUrl, appkey, appSecret));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initRefreshThread(final DefaultTaobaoClient client) {
        if (refreshThread == null) {
            Object object = initLock;
            synchronized (object) {
                if (refreshThread == null) {
                    try {
                        dnsConfig = ClusterManager.getDnsConfigFromTop(client);
                    }
                    catch (ApiException apiException) {
                        if (apiException.getErrCode() != null && terminationCodeSet.contains(apiException.getErrCode())) {
                            log.error((Object)("http dns server termination,errCode:" + apiException.getErrCode() + "," + apiException.getErrMsg()));
                            return;
                        }
                        log.error((Object)("get http dns config from top fail," + apiException.getErrCode() + "," + apiException.getErrMsg()));
                    }
                    catch (Exception e) {
                        log.error((Object)"get http dns config from top fail", (Throwable)e);
                    }
                    refreshThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            while (true) {
                                try {
                                    while (true) {
                                        int refreshInterval = dnsConfig == null ? 1 : dnsConfig.getRefreshInterval();
                                        ClusterManager.sleep((long)(refreshInterval * 60) * 1000L);
                                        DnsConfig rempteConfig = ClusterManager.getDnsConfigFromTop(client);
                                        if (rempteConfig != null && rempteConfig.getVersion() > dnsConfig.getVersion()) {
                                            dnsConfig = rempteConfig;
                                        }
                                        client.resetServerUrl(defaultServerUrl);
                                    }
                                }
                                catch (ApiException apiException) {
                                    if (apiException.getErrCode() != null && terminationCodeSet.contains(apiException.getErrCode())) {
                                        log.error((Object)("http dns server termination,errCode:" + apiException.getErrCode() + "," + apiException.getErrMsg()));
                                        return;
                                    }
                                    if (dnsConfig != null) {
                                        if (client.getRequestUrl().equals(defaultServerUrl)) {
                                            String szServerUrl = dnsConfig.getEnvVip("sz", defaultServerUrl);
                                            client.resetServerUrl(szServerUrl);
                                        } else {
                                            client.resetServerUrl(defaultServerUrl);
                                        }
                                    }
                                    log.error((Object)("get http dns config from top fail," + apiException.getErrCode() + "," + apiException.getErrMsg() + " next url : " + client.getRequestUrl()));
                                    continue;
                                }
                                catch (Exception e) {
                                    log.error((Object)("refresh http dns config from top fail," + e.getMessage()), (Throwable)e);
                                    ClusterManager.sleep(3000L);
                                    continue;
                                }
                                break;
                            }
                        }
                    });
                    refreshThread.setDaemon(true);
                    refreshThread.setName("HTTP_DNS_REFRESH_THREAD");
                    refreshThread.start();
                }
            }
        }
    }

    private static DnsConfig getDnsConfigFromTop(TaobaoClient client) throws ApiException {
        HttpdnsGetRequest req = new HttpdnsGetRequest();
        HttpdnsGetResponse rsp = client.execute(req);
        if (rsp.isSuccess()) {
            return DnsConfig.parse(rsp.getResult());
        }
        throw new ApiException(rsp.getErrorCode(), rsp.getMsg());
    }

    private static void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    static {
        terminationCodeSet.add("21");
        terminationCodeSet.add("22");
        terminationCodeSet.add("25");
        terminationCodeSet.add("28");
        terminationCodeSet.add("29");
    }
}

