package com.elitesland.yst.wms.connector.constant.yst.enums;

import lombok.Getter;

/**
 * 接口方向
 */
@Getter
public enum InterfaceTypeEnum {

    C_ITEM("商品创建", InterfaceDirEnum.O),
    U_ITEM("商品更新", InterfaceDirEnum.O),
    C_ODO("出库单创建", InterfaceDirEnum.O),
    C_DO_ODO("发货单创建", InterfaceDirEnum.O),
    C_IDO("入库单创建", InterfaceDirEnum.O),
    C_RTN_IDO("退货入库单创建", InterfaceDirEnum.O),
    ODO_R("出库结果回传", InterfaceDirEnum.O),
    IDO_R("入库结果回传", InterfaceDirEnum.O)
    ;

    private String interfaceName;
    private InterfaceDirEnum interfaceDirEnum;

    InterfaceTypeEnum(String interfaceName, InterfaceDirEnum dirEnum) {
        this.interfaceName = interfaceName;
        this.interfaceDirEnum = dirEnum;
    }

    public String toCaption() {
        return interfaceName + "[" + name() + "]";
    }
}
