package com.elitesland.yst.wms.connector.client.api.request;

import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;
import com.elitesland.yst.wms.connector.client.api.response.InventorySynchronizeResponse;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * TOP API: taobao.qimen.inventory.synchronize request
 *
 * @author top auto create
 * @since 1.0, 2023.04.21
 */
@Data
public class TtxInvCkApproveSyncRequest extends YstWmsRequest<InventorySynchronizeResponse> {
    /**
     * 盘点单据编码
     */
    @ApiModelProperty("盘点单据编码")
    private String code;

    /**
     * 盘点单明细ID
     */
    @ApiModelProperty("盘点单明细ID")
    private List<Long> detailIds;

    @Override
    public String getApiMethodName() {
        return "ttx.invck.approve";
    }


    @Override
    public Class<InventorySynchronizeResponse> getResponseClass() {
        return InventorySynchronizeResponse.class;
    }

}
