package com.elitesland.yst.wms.connector.client.api.request;

import com.elitesland.yst.wms.connector.client.api.YstWmsRequest;
import com.elitesland.yst.wms.connector.client.api.response.EntryorderResponse;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * TOP API: taobao.qimen.entryorder.confirm request
 * 
 * @author top auto create
 * @since 1.0, 2024.01.23
 */
@Data
public class UnifiedEntryOrderRequest extends YstWmsRequest<EntryorderResponse> {
    // 表头(基本信息)
    @ApiModelProperty("到货通知单号")
    private String ssDocNo;

    @ApiModelProperty("WMS入库单号")
    private String wmsIdoId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("入库单类型")
    private String idoType;

    @ApiModelProperty("客商编码")
    private String enterpriseCode;

    // 行项目(收货验收明细信息)
    @ApiModelProperty("明细")
    private List<InvPurLdoConfirmGrQtDtlParam> invPurLdoConfirmSsLdoDtlParams;

    @Data
    public static class InvPurLdoConfirmGrQtDtlParam {

        @ApiModelProperty("商品编码")
        private String itemCode;

        @ApiModelProperty("商品名称")
        private String itemName;

        @ApiModelProperty("规格型号")
        private String spec;

        @ApiModelProperty("浓度规格")
        private String concSpec;

        @ApiModelProperty("条码")
        private String barcode;

        @ApiModelProperty("收货数量")
        private BigDecimal qty;

        @ApiModelProperty("拒收数")
        private BigDecimal rejectQty;

        @ApiModelProperty("合格数")
        private BigDecimal okQty;

        @ApiModelProperty("不合格数")
        private BigDecimal noQty;

        @ApiModelProperty("单位")
        private String uom;

        @ApiModelProperty("批次号")
        private String lotNo;

        @ApiModelProperty("生产日期")
        private String manuDate;

        @ApiModelProperty("有效期至")
        private String expiredDate;

        @ApiModelProperty("生产厂家")
        private String manuFactory;

        @ApiModelProperty("批准文号\\备案证号\\注册证号")
        private String approvalNumber;

        @ApiModelProperty("产地")
        private String origin;

        @ApiModelProperty("剂型")
        private String dosageForm;

        @ApiModelProperty("行号")
        private Double lineNo;

        @ApiModelProperty("入库日期")
        private String wmsDate;

        @ApiModelProperty("产品批号")
        private String productNo;

        @ApiModelProperty("入库数辅助单位")
        private String uom2;

        @ApiModelProperty("拒收原因")
        private String rejectReason;
    }


    @Override
    public String getApiMethodName() {
        return "unified.entryorder.confirm request";
    }

    @Override
    public Class<EntryorderResponse> getResponseClass() {
        return EntryorderResponse.class;
    }
}