package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.FuwuPurchaseOrderPayResponse;

/**
 * TOP API: taobao.fuwu.purchase.order.pay request
 * 
 * @author top auto create
 * @since 1.0, 2025.03.26
 */
public class FuwuPurchaseOrderPayRequest extends BaseTaobaoRequest<FuwuPurchaseOrderPayResponse> {
	
	

	/** 
	* APPKEY，必填
	 */
	private String appkey;

	/** 
	* 设备类型，目前只支持PC，可选
	 */
	private String deviceType;

	/** 
	* 订单号，与外部订单号二选一
	 */
	private Long orderId;

	/** 
	* 外部订单号，使用该参数完成查询订单等操作，与外部订单号二选一
	 */
	private String outOrderId;

	public void setAppkey(String appkey) {
		this.appkey = appkey;
	}

	public String getAppkey() {
		return this.appkey;
	}

	public void setDeviceType(String deviceType) {
		this.deviceType = deviceType;
	}

	public String getDeviceType() {
		return this.deviceType;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getOrderId() {
		return this.orderId;
	}

	public void setOutOrderId(String outOrderId) {
		this.outOrderId = outOrderId;
	}

	public String getOutOrderId() {
		return this.outOrderId;
	}

	public String getApiMethodName() {
		return "taobao.fuwu.purchase.order.pay";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("appkey", this.appkey);
		txtParams.put("device_type", this.deviceType);
		txtParams.put("order_id", this.orderId);
		txtParams.put("out_order_id", this.outOrderId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<FuwuPurchaseOrderPayResponse> getResponseClass() {
		return FuwuPurchaseOrderPayResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(appkey, "appkey");
	}
	

}