package com.elitesland.yst.wms.connector.constant;

import com.elitescloud.cloudt.system.vo.DprUdcVO;
import lombok.Getter;

import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2025-04-03 16:56
 */
public enum WmsCallBackStausEnum implements BasicWmsUdcEnumInterface {

    TO_BE_NOTIFIED("待通知",1),
    AT_NOTICE("通知中",2),
    HAVE_NOTIFIED_SUCCESS("已通知-成功",3),
    HAVE_NOTIFIED_FAILURE("已通知-失败",4),
 ;
    @Getter
    private String description;

    private final DprUdcVO udcVO;

    WmsCallBackStausEnum(String description, int sortNo) {
        this.description = description;
        this.udcVO = newUdcVo("YST-WMSC", "WmsCallBackStausEnum", "WMS反向回调状态", description, sortNo, name());
    }

    @Override
    public DprUdcVO getUdcVO() {
        return udcVO;
    }

    @Override
    public String getValueDescription() {
        return udcVO.getValDesc();
    }

    // 静态方法通过接口工具类实现
    public static List<DprUdcVO> getAllUdc() {
        return BasicWmsUdcEnumInterface.getUdcList(WmsConnectorRouterCallType.class);
    }

    public static String getDescription(String key) {
        return BasicWmsUdcEnumInterface.getDescription(WmsConnectorRouterCallType.class, key);
    }
}
