/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.remoting;

import com.taobao.api.internal.toplink.DefaultLoggerFactory;
import com.taobao.api.internal.toplink.LoggerFactory;
import com.taobao.api.internal.toplink.remoting.MethodCall;
import com.taobao.api.internal.toplink.remoting.MethodCallContext;
import com.taobao.api.internal.toplink.remoting.MethodCallProcessor;
import com.taobao.api.internal.toplink.remoting.MethodReturn;
import com.taobao.api.internal.toplink.remoting.RemotingServerChannelHandler;
import java.net.URI;
import java.util.HashMap;

public class DefaultRemotingServerChannelHandler
extends RemotingServerChannelHandler {
    private HashMap<String, MethodCallProcessor> services = new HashMap();

    public DefaultRemotingServerChannelHandler() {
        this(DefaultLoggerFactory.getDefault());
    }

    public DefaultRemotingServerChannelHandler(LoggerFactory loggerFactory) {
        super(loggerFactory);
    }

    public final void addProcessor(String objectUri, MethodCallProcessor processor) {
        this.services.put("/" + objectUri.toLowerCase(), processor);
    }

    @Override
    public final MethodReturn onMethodCall(MethodCall methodCall, MethodCallContext callContext) throws Throwable {
        String objectUri = new URI(methodCall.Uri).getRawPath().trim();
        MethodCallProcessor processor = this.services.get(objectUri);
        if (processor == null) {
            throw new NullPointerException(String.format("processor not found for objectUri: %s", objectUri));
        }
        return processor.process(methodCall, callContext);
    }
}

