package com.elitesland.yst.wms.connector.rpc;


import com.elitesland.yst.wms.connector.Application;
import com.elitesland.yst.wms.connector.client.YstWmsRequestClient;
import com.elitesland.yst.wms.connector.client.api.response.EntryorderConfirmResponse;
import com.elitesland.yst.wms.connector.client.api.response.InventoryReportResponse;
import com.elitesland.yst.wms.connector.client.api.response.StockoutConfirmResponse;
import com.elitesland.yst.wms.connector.dto.InventoryReportDTO;
import com.elitesland.yst.wms.connector.dto.StockoutConfirmDTO;
import com.elitesland.yst.wms.connector.dto.TtxEntryorderConfirmDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;

@Validated
@FeignClient(name = Application.NAME, path = YstWmsRequestClient.PASSIVE_CALL_API_URL + "/zyyy")
public interface ZyyyWmsCallBackProvider {

    @PostMapping("/entryorder/confirm")
    @ApiOperation("入库确认回调通知")
    EntryorderConfirmResponse entryOrderConfirm(@RequestBody TtxEntryorderConfirmDTO requestDto);

    @PostMapping("/inventory/report")
    @ApiOperation("库存盘点回调通知")
    InventoryReportResponse deliveryOrder(@RequestBody InventoryReportDTO requestDto);

    @PostMapping("/test")
    @ApiOperation("获取指定Token")
    String test(@RequestParam("test") String test);

    @PostMapping("/stockout/confirm")
    @ApiOperation("出库单确认回调通知")
    StockoutConfirmResponse stockoutConfirm(@RequestBody StockoutConfirmDTO stockoutConfirmDTO);

}
