/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.handler;

import com.taobao.api.internal.toplink.embedded.websocket.WebSocket;
import com.taobao.api.internal.toplink.embedded.websocket.exception.WebSocketException;
import com.taobao.api.internal.toplink.embedded.websocket.frame.Frame;
import com.taobao.api.internal.toplink.embedded.websocket.handler.StreamHandler;
import com.taobao.api.internal.toplink.embedded.websocket.handler.StreamHandlerChain;
import com.taobao.api.internal.toplink.embedded.websocket.util.PacketDumpUtil;
import java.nio.ByteBuffer;

public class PacketDumpStreamHandler
implements StreamHandler {
    @Override
    public void nextDownstreamHandler(WebSocket ws, ByteBuffer buffer, Frame frame, StreamHandlerChain chain) throws WebSocketException {
        if (PacketDumpUtil.isDump(ws, 1)) {
            PacketDumpUtil.printPacketDump("FR Downstream", buffer);
        }
        chain.nextDownstreamHandler(ws, buffer, frame);
    }

    @Override
    public void nextHandshakeDownstreamHandler(WebSocket ws, ByteBuffer buffer, StreamHandlerChain chain) throws WebSocketException {
        if (PacketDumpUtil.isDump(ws, 2)) {
            PacketDumpUtil.printPacketDump("HS Downstream", buffer);
        }
        chain.nextHandshakeDownstreamHandler(ws, buffer);
    }

    @Override
    public void nextHandshakeUpstreamHandler(WebSocket ws, ByteBuffer buffer, StreamHandlerChain chain) throws WebSocketException {
        if (PacketDumpUtil.isDump(ws, 8)) {
            PacketDumpUtil.printPacketDump("HS Upstream", buffer);
        }
        chain.nextHandshakeUpstreamHandler(ws, buffer);
    }

    @Override
    public void nextUpstreamHandler(WebSocket ws, ByteBuffer buffer, Frame frame, StreamHandlerChain chain) throws WebSocketException {
        if (PacketDumpUtil.isDump(ws, 4)) {
            PacketDumpUtil.printPacketDump("FR Upstream", buffer);
        }
        chain.nextUpstreamHandler(ws, buffer, frame);
    }
}

