/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.util;

import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.internal.util.StringUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class XmlWriter {
    private StringBuffer buf = new StringBuffer();
    private Stack<Object> calls = new Stack();
    private boolean omitClassName;
    private String rootTagName;
    private Class<?> stopClass;
    private Set<String> stopProps;

    public XmlWriter(boolean omitClassName, String rootTagName, Class<?> stopClass) {
        this.omitClassName = omitClassName;
        this.rootTagName = rootTagName;
        this.stopClass = stopClass;
        this.stopProps = StringUtils.getClassProperties(stopClass, true);
    }

    public XmlWriter() {
        this(true, null, null);
    }

    public String write(Object object) {
        this.buf.setLength(0);
        String tagName = this.rootTagName;
        if (tagName == null) {
            tagName = StringUtils.toCamelStyle(object.getClass().getSimpleName());
        }
        this.startTag(tagName);
        this.value(object);
        this.endTag(tagName);
        return this.buf.toString();
    }

    private void value(Object object) {
        if (object == null || this.cyclic(object)) {
            this.add(null);
        } else {
            this.calls.push(object);
            if (object instanceof Class) {
                this.string(object);
            } else if (object instanceof Boolean) {
                this.bool((Boolean)object);
            } else if (object instanceof Number) {
                this.add(object);
            } else if (object instanceof String) {
                this.string(object);
            } else if (object instanceof Character) {
                this.string(object);
            } else if (object instanceof Map) {
                this.map((Map)object);
            } else if (object.getClass().isArray()) {
                this.array(object);
            } else if (object instanceof Collection) {
                this.array((Collection)object);
            } else if (object instanceof Date) {
                this.date((Date)object);
            } else {
                this.bean(object);
            }
            this.calls.pop();
        }
    }

    private boolean cyclic(Object object) {
        for (Object e : this.calls) {
            if (object != e) continue;
            return true;
        }
        return false;
    }

    private void bean(Object object) {
        try {
            BeanInfo info = Introspector.getBeanInfo(object.getClass());
            boolean isChildren = this.stopClass != null && this.stopClass.isAssignableFrom(object.getClass());
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            for (int i = 0; i < props.length; ++i) {
                Object value;
                PropertyDescriptor prop = props[i];
                String name = prop.getName();
                if (isChildren && this.stopProps.contains(name)) continue;
                Method accessor = prop.getReadMethod();
                if (this.omitClassName && "class".equals(name) || accessor == null) continue;
                if (!accessor.isAccessible()) {
                    accessor.setAccessible(true);
                }
                if ((value = accessor.invoke(object, (Object[])null)) == null) continue;
                this.add(name, value);
            }
            Field[] ff = object.getClass().getFields();
            for (int i = 0; i < ff.length; ++i) {
                Field field = ff[i];
                Object value = field.get(object);
                if (value == null) continue;
                this.add(field.getName(), value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void add(String name, Object value) {
        this.startTag(name);
        this.value(value);
        this.endTag(name);
    }

    private void map(Map<?, ?> map) {
        for (Map.Entry<?, ?> e : map.entrySet()) {
            this.startTag(String.valueOf(e.getKey()));
            this.value(e.getValue());
            this.endTag(String.valueOf(e.getKey()));
        }
    }

    private void array(Collection<?> object) {
        String tagName = null;
        for (Object item : object) {
            if (tagName == null) {
                ApiListType apiListType = item.getClass().getAnnotation(ApiListType.class);
                tagName = apiListType != null ? apiListType.value() : StringUtils.toCamelStyle(item.getClass().getSimpleName());
            }
            this.startTag(tagName);
            this.value(item);
            this.endTag(tagName);
        }
    }

    private void array(Object object) {
        String tagName = null;
        int length = Array.getLength(object);
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(object, i);
            if (tagName == null) {
                tagName = StringUtils.toCamelStyle(item.getClass().getSimpleName());
            }
            this.startTag(tagName);
            this.value(item);
            this.endTag(tagName);
        }
    }

    private void bool(boolean b) {
        this.add(b ? "true" : "false");
    }

    private void date(Date date) {
        this.add(StringUtils.formatDateTime(date));
    }

    private void string(Object obj) {
        this.add(StringUtils.escapeXml(obj.toString()));
    }

    private void add(Object obj) {
        this.buf.append(obj);
    }

    private void startTag(String tagName) {
        this.buf.append("<");
        this.buf.append(tagName);
        this.buf.append(">");
    }

    private void endTag(String tagName) {
        this.buf.append("</");
        this.buf.append(tagName);
        this.buf.append(">");
    }
}

