package com.elitesland.zhiyuan.openapi.outer.jackyun.service.impl;

import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.jackyun.client.GikyCloudClient;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.GikyCloudResponse;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.MaterialCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.VendCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.result.GikyCloudResult;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.JackyunService;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.Map;
@Slf4j
@Service
@RequiredArgsConstructor
// 配置文件动态刷新
@RefreshScope
public class JackyunServiceImpl implements JackyunService {

    @Autowired
    private GikyCloudClient gikyCloudClient;

    private final OutsidePushRecordRepository outsidePushRecordRepository;
    @Autowired
    private ObjectMapper objectMapper;


    @Override
    @Transactional
    public String createMaterial(MaterialCreateRequest request) throws Exception {
        // 安全校验必填字段（业务层应前置校验）
        if (StringUtils.isBlank(request.getGoodsNo())) {
            throw new IllegalArgumentException("货品编码 goodsNo 不能为空");
        }
        if (StringUtils.isBlank(request.getGoodsName())) {
            throw new IllegalArgumentException("货品名称 goodsName 不能为空");
        }
        Map<String, Object> bizData = new HashMap<>();
        bizData.put("goodsNo", request.getGoodsNo());
        bizData.put("goodsName", request.getGoodsName());
        bizData.put("unitName", request.getUnitName());
        bizData.put("outSkuCode", request.getGoodsNo());

        // 仅非空时放入
        if (StringUtils.isNotBlank(request.getGoodsNameEn())) {
            bizData.put("goodsNameEn", request.getGoodsNameEn());
        }
        if (StringUtils.isNotBlank(request.getSkuBarcode())) {
            bizData.put("skuBarcode", request.getSkuBarcode());
        }
        if (StringUtils.isNotBlank(request.getDescript())) {
            bizData.put("description", request.getDescript());
        }
        return parseGikyResponse(gikyCloudClient.post(
                "erp.material.create.v2",
                "v1.0",
                null,
                bizData
        ));
    }

    private String parseGikyResponse(String responseStr) throws Exception {
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType("JKY");
        pushRecordDTO.setDocNo("");
        pushRecordDTO.setDocId(0L);
        pushRecordDTO.setReqSuccess(false);
        GikyCloudResult result = getGikyCloudResult(responseStr);
        pushRecordDTO.setRespBody(result);

        Map<String, Object> data = result.getData();
        String materialId = (String) data.get("materialId");
        if (materialId == null) {
            pushRecordDTO.setReqSuccess(false);
            throw new RuntimeException("吉客云返回结果缺少物料ID");
        }
        outsidePushRecordRepository.savePushRecord(pushRecordDTO);

        return materialId;
    }
    @Override
    @Transactional
    public String createVendor(VendCreateRequest request)  throws Exception{
        request.validate();
        Map<String, Object> bizData = new HashMap<>();
        bizData.put("code", request.getCode());
        bizData.put("name", request.getName());
        return parseSuppGikyResponse(gikyCloudClient.post(
                "erp.vend.create.v2",
                "v1.0",
                null,
                bizData
        ));
    }

    private String parseSuppGikyResponse(String responseStr) throws Exception {

        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType("JKY");
        pushRecordDTO.setDocNo("");
        pushRecordDTO.setDocId(0L);
        pushRecordDTO.setReqSuccess(true);
        GikyCloudResult result = getGikyCloudResult(responseStr);
        pushRecordDTO.setRespBody(result);

        Map<String, Object> data = result.getData();
        String vendId = (String) data.get("vendId");
        if (vendId == null) {
            pushRecordDTO.setReqSuccess(false);
            throw new RuntimeException("吉客云返回结果缺少供应商ID");

        }
        outsidePushRecordRepository.savePushRecord(pushRecordDTO);
        return vendId;
    }
    private GikyCloudResult getGikyCloudResult(String responseStr) throws Exception {
        GikyCloudResponse<GikyCloudResult> response = objectMapper.readValue(
                responseStr,
                objectMapper.getTypeFactory().constructParametricType(
                        GikyCloudResponse.class, GikyCloudResult.class
                )
        );

        if (response.getCode() != 200) {
            throw new RuntimeException(
                    "吉客云接口调用失败: " + response.getMsg() +
                            " (subCode: " + response.getSubCode() + ")"
            );
        }

        GikyCloudResult result = response.getResult();
        if (result == null || result.getData() == null) {
            throw new RuntimeException("吉客云返回结果为空");
        }
        return result;
    }
}