package com.elitesland.zhiyuan.openapi.outer.nc.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.zhiyuan.openapi.outer.nc.service.NcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * NC接口测试控制器
 *
 * @author duwh
 */
@RestController
@RequestMapping("/nc/test")
@RequiredArgsConstructor
@Api(value = "NC接口测试", tags = {"NC接口测试"})
public class NcTestController {

    private final NcService ncService;

    @PostMapping("/test")
    @ApiOperation("测试NC")
    public ApiResult<String> test() {
        try {
            String result = ncService.test();
            return ApiResult.ok(result);
        } catch (Exception e) {
            return ApiResult.fail("测试失败: " + e.getMessage());
        }
    }

}
