package com.elitesland.zhiyuan.openapi.outer.jackyun.service.impl;

import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.jackyun.client.GikyCloudClient;
import com.elitesland.zhiyuan.openapi.outer.jackyun.client.JackyunOpenHttpUtils;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.ErpGoodsSkuimPortBatchRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.ErpVendCreateV2RequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.MaterialCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.VendCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.JackyunService;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
@Slf4j
@Service
@RequiredArgsConstructor
// 配置文件动态刷新
@RefreshScope
public class JackyunServiceImpl implements JackyunService {

    @Autowired
    private GikyCloudClient gikyCloudClient;

    private final OutsidePushRecordRepository outsidePushRecordRepository;
    @Autowired
    private ObjectMapper objectMapper;


    @Override
    @Transactional
    public String createMaterial(MaterialCreateRequest request) throws Exception {
        // 安全校验必填字段（业务层应前置校验）
        if (StringUtils.isBlank(request.getGoodsNo())) {
            throw new IllegalArgumentException("货品编码 goodsNo 不能为空");
        }
        if (StringUtils.isBlank(request.getGoodsName())) {
            throw new IllegalArgumentException("货品名称 goodsName 不能为空");
        }
        ErpGoodsSkuimPortBatchRequestBizData erpbizData  = new ErpGoodsSkuimPortBatchRequestBizData();

        erpbizData.setGoodsNo(request.getGoodsNo());
        erpbizData.setGoodsName(request.getGoodsName());

        erpbizData.setOutSkuCode(request.getGoodsNo());
        return parseGikyResponse(JackyunOpenHttpUtils.post(
                "erp.goods.skuimportbatch",
                "v1.0",
                null,
                erpbizData
        ));
    }

    private String parseGikyResponse(String responseStr) throws Exception {
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType("JKY");
        pushRecordDTO.setDocNo("");
        pushRecordDTO.setDocId(0L);
        pushRecordDTO.setReqSuccess(false);
        pushRecordDTO.setRespBody(responseStr);
        outsidePushRecordRepository.savePushRecord(pushRecordDTO);

        return "materId";
    }
    @Override
    @Transactional
    public String createVendor(VendCreateRequest request)  throws Exception{
        request.validate();
        ErpVendCreateV2RequestBizData erpbizData = new ErpVendCreateV2RequestBizData();
        erpbizData.setCode(request.getCode());
        erpbizData.setName(request.getName());
        return parseSuppGikyResponse(JackyunOpenHttpUtils.post(
                "erp.vend.create.v2",
                "v1.0",
                null,
                erpbizData
        ));
    }

    private String parseSuppGikyResponse(String responseStr) throws Exception {

        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType("JKY");
        pushRecordDTO.setDocNo("");
        pushRecordDTO.setDocId(0L);
        pushRecordDTO.setReqSuccess(true);
        pushRecordDTO.setRespBody(responseStr);
        outsidePushRecordRepository.savePushRecord(pushRecordDTO);

        return "vendId";
    }

}