package com.elitesland.zhiyuan.openapi.outer.jushuitan.service.impl;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.jggyun.params.SupplierRequest;
import com.elitesland.zhiyuan.openapi.outer.jggyun.params.UpdateGoodsRequest;
import com.elitesland.zhiyuan.openapi.outer.jggyun.result.UpdateGoodsResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.service.JushuitaService;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.util.NotaoUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Slf4j
@Service
@RequiredArgsConstructor
// 配置文件动态刷新
@RefreshScope
public class JushuitaServiceImpl implements JushuitaService {

    private final OutsidePushRecordRepository outsidePushRecordRepository;

    @Override
    @Transactional
    public String createMaterial(UpdateGoodsRequest request) throws Exception {
        //2.接口组装,接口发送
        log.info("聚水潭物料接口 查询入参：" + JSON.toJSONString(request));
        // 1. 构建商品对象 Map (包含所有字段)
        Map<String, Object> itemMap = buildItemMap(request);

        // 2. 构建请求 Map (包含 items 数组)
        Map<String, Object> requestMap = new HashMap<>();
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType("JST");
        pushRecordDTO.setDocNo("");
        pushRecordDTO.setDocId(0L);
        pushRecordDTO.setReqSuccess(false);
        requestMap.put("items", Collections.singletonList(itemMap));
        // 转换为 JSON 字符串
        String json = JSON.toJSONString(requestMap);
        pushRecordDTO.setReqBody(requestMap);
        // 调用底层接口
        String response = NotaoUtil.getSellerItem(json, "/open/jushuitan/itemsku/upload");
        // 处理API响应
        if (response != null) {
            // 使用 FastJSON 将 JSON 字符串解析为 Java 对象
            UpdateGoodsResponse response1 = JSON.parseObject(response, UpdateGoodsResponse.class);
            if (response1.getData() != null && response1.getData().getDatas() != null) {
                for (UpdateGoodsResponse.Datas data : response1.getData().getDatas()) {
                    pushRecordDTO.setReqSuccess(data.isSuccess());
                }
            }
            pushRecordDTO.setRespBody(response);

        } else {
            System.out.println("API请求返回为空");
        }

        outsidePushRecordRepository.savePushRecord(pushRecordDTO);
        log.info("聚水潭物料接口 查询结果：" + JSON.toJSONString(response));
        return response;
    }

    private Map<String, Object> buildItemMap(UpdateGoodsRequest request) {
        Map<String, Object> itemMap = new HashMap<>();

        // ✅ 必填字段 (必须存在)
        itemMap.put("sku_id", request.getItems().get(0).getSkuId());
        itemMap.put("i_id", request.getItems().get(0).getIId());
        itemMap.put("name", request.getItems().get(0).getName());
        return itemMap;
    }


    /**
     * 同步供应商信息至聚水潭
     *
     * @param request 请求对象，包含 sku_id, stock_qty, warehouse_id 等
     * @return 聚水潭返回的结果字符串（JSON 格式）
     * @throws Exception 请求异常或远程调用失败
     */
    @Override
    @Transactional
    public String syncSupp(SupplierRequest request) throws Exception {
        log.info("聚水潭供应商同步接口 - 请求入参: {}", JSON.toJSONString(request));
        try {
            // 1. 构建供应商列表（严格按字段顺序）
            List<Map<String, Object>> suppliers = new ArrayList<>();
            for (SupplierRequest.SupplierItem item : request.getSuppliers()) {
                suppliers.add(buildSupplierItemMap(item));
            }
            // 2. 直接序列化为 JSON 数组（根结构是数组）
            String jsonRequest = JSON.toJSONString(suppliers);
            log.info("聚水潭供应商同步接口 - 发送数据: {}", jsonRequest);
            PushRecordDTO pushRecordDTO = new PushRecordDTO();
            pushRecordDTO.setInterType("JST");
            pushRecordDTO.setDocNo("");
            pushRecordDTO.setDocId(0L);
            pushRecordDTO.setReqSuccess(false);
            pushRecordDTO.setReqBody(request);
            // 3. 调用聚水潭通用 HTTP 工具发送请求
            String response = NotaoUtil.getSellerItem(jsonRequest, "/open/supplier/upload");
            // 处理API响应
            if (response != null) {
                // 使用 FastJSON 将 JSON 字符串解析为 Java 对象
                UpdateGoodsResponse response1 = JSON.parseObject(response, UpdateGoodsResponse.class);
                if (response1.getData() != null && response1.getData().getDatas() != null) {
                    for (UpdateGoodsResponse.Datas data : response1.getData().getDatas()) {
                        pushRecordDTO.setReqSuccess(data.isSuccess());
                    }
                }
                pushRecordDTO.setRespBody(response);

            } else {
                System.out.println("API请求返回为空");
            }
            outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            return response;

        } catch (Exception e) {
            log.error("聚水潭供应商同步接口调用发生异常", e);
            throw new Exception("调用聚水潭供应商同步接口失败: " + e.getMessage(), e);
        }
    }

    private Map<String, Object> buildSupplierItemMap(SupplierRequest.SupplierItem item) {
        Map<String, Object> map = new HashMap<>();

        // ✅ 严格按您提供的字段顺序构建
        map.put("supplier_code", item.getSupplier_code());
        map.put("name", item.getName());
        map.put("enabled", true);

        return map;
    }
}