package com.elitesland.zhiyuan.openapi.outer.jackyun.service.impl;

import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.jackyun.client.GikyCloudClient;
import com.elitesland.zhiyuan.openapi.outer.jackyun.client.JackyunOpenHttpUtils;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.ErpGoodsSkuimPortBatchRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.ErpVendCreateV2RequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.MaterialCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.VendCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.JackyunService;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Slf4j
@Service
@RequiredArgsConstructor
@RefreshScope
public class JackyunServiceImpl implements JackyunService {

    @Autowired
    private GikyCloudClient gikyCloudClient;

    private final OutsidePushRecordRepository outsidePushRecordRepository;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    @Transactional
    public String createMaterial(MaterialCreateRequest request) throws Exception {
        try {
            // 记录请求开始
            log.info("开始创建物料，请求参数: [goodsNo={}] [goodsName={}]",
                    request.getGoodsNo(), request.getGoodsName());

            // 业务校验
            if (StringUtils.isBlank(request.getGoodsNo())) {
                throw new IllegalArgumentException("货品编码 goodsNo 不能为空");
            }
            if (StringUtils.isBlank(request.getGoodsName())) {
                throw new IllegalArgumentException("货品名称 goodsName 不能为空");
            }

            // 构建请求数据
            ErpGoodsSkuimPortBatchRequestBizData erpbizData = new ErpGoodsSkuimPortBatchRequestBizData();
            erpbizData.setGoodsNo(request.getGoodsNo());
            erpbizData.setGoodsName(request.getGoodsName());
            erpbizData.setOutSkuCode(request.getGoodsNo());

            // 调用外部接口
            String responseStr = JackyunOpenHttpUtils.post(
                    "erp.goods.skuimportbatch",
                    "v1.0",
                    null,
                    erpbizData
            );
            log.debug("物料创建接口调用成功，请求参数: [{}], 响应内容: [{}]",
                    erpbizData, responseStr);

            // 处理响应
            return parseGikyResponse(responseStr, "createMaterial", request.getGoodsNo());
        } catch (Exception e) {
            // 记录异常日志
            log.error("物料创建失败，请求参数: [goodsNo={}] [goodsName={}]",
                    request.getGoodsNo(), request.getGoodsName(), e);
            throw e;
        }
    }

    @Override
    @Transactional
    public String createVendor(VendCreateRequest request) throws Exception {
        try {
            // 记录请求开始
            log.info("开始创建供应商，请求参数: [code={}] [name={}]",
                    request.getCode(), request.getName());

            // 业务校验
            request.validate();

            // 构建请求数据
            ErpVendCreateV2RequestBizData erpbizData = new ErpVendCreateV2RequestBizData();
            erpbizData.setCode(request.getCode());
            erpbizData.setName(request.getName());

            // 调用外部接口
            String responseStr = JackyunOpenHttpUtils.post(
                    "erp.vend.create.v2",
                    "v1.0",
                    null,
                    erpbizData
            );
            log.debug("供应商创建接口调用成功，请求参数: [{}], 响应内容: [{}]",
                    erpbizData, responseStr);

            // 处理响应
            return parseSuppGikyResponse(responseStr, "createVendor", request.getCode());
        } catch (Exception e) {
            // 记录异常日志
            log.error("供应商创建失败，请求参数: [code={}] [name={}]",
                    request.getCode(), request.getName(), e);
            throw e;
        }
    }

    private String parseGikyResponse(String responseStr, String method, String goodsNo) {
        // 创建日志记录
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType("JKY");
        pushRecordDTO.setDocNo(goodsNo);
        pushRecordDTO.setDocId(0L);
        pushRecordDTO.setReqSuccess(true); // 业务调用成功，但实际响应需根据业务判断
        pushRecordDTO.setRespBody(responseStr);

        try {
            log.debug("物料创建日志记录成功，物料编码: {}", goodsNo);
            // 保存日志记录
            outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            return "materId";
        } catch (Exception e) {
            pushRecordDTO.setErrorMsg(e.getMessage());
            pushRecordDTO.setReqSuccess(false);
            // 日志记录失败时记录错误日志
            log.error("物料创建日志记录失败，物料编码: {}, 响应内容: {}", goodsNo, responseStr, e);
            // 仍然返回模拟ID，避免影响业务流程
            return "materId";
        }
    }

    private String parseSuppGikyResponse(String responseStr, String method, String code) {
        // 创建日志记录
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType("JST");
        pushRecordDTO.setDocNo(code);
        pushRecordDTO.setDocId(0L);
        pushRecordDTO.setReqSuccess(true); // 业务调用成功
        pushRecordDTO.setRespBody(responseStr);
        try {

            // 保存日志记录
            outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            log.debug("供应商创建日志记录成功，供应商编码: {}", code);

            return "vendId";
        } catch (Exception e) {
            pushRecordDTO.setErrorMsg(e.getMessage());
            pushRecordDTO.setReqSuccess(false);
            // 日志记录失败时记录错误日志
            log.error("供应商创建日志记录失败，供应商编码: {}, 响应内容: {}", code, responseStr, e);
            // 保存日志记录
            outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            // 仍然返回模拟ID，避免影响业务流程
            return "vendId";
        }
    }
}