package com.elitesland.zhiyuan.openapi.outer.jackyun.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.JackyunResponse;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.core.BaseRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpgoodskuimportbatch.ErpGoodsSkuimPortBatchRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpgoodskuimportbatch.ErpGoodsSkuimPortBatchResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpvendcreatev2.ErpVendCreateV2RequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.erp.erpvendcreatev2.ErpVendCreateV2ResponseBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.core.ApiEnum;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.MaterialCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.params.VendCreateRequest;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.JackyunOpenClientService;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.JackyunService;
import com.elitesland.zhiyuan.openapi.outer.jackyun.util.JsonUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
@RequiredArgsConstructor
@RefreshScope
public class JackyunServiceImpl implements JackyunService {

    /**
     * 请求吉客云开放平台服务
     */
    private final JackyunOpenClientService clientService = new JackyunOpenClientService();

    private final OutsidePushRecordRepository outsidePushRecordRepository;


    /**
     * 物料创建请求接口
     *
     * @param materialCreateRequest
     * @return
     */
    @Override
    public JackyunResponse createMaterial(MaterialCreateRequest materialCreateRequest) {
        // 记录请求开始
        log.info("开始创建物料，请求参数: [goodsNo={}] [goodsName={}]",
                materialCreateRequest.getGoodsNo(), materialCreateRequest.getGoodsName());
        // 业务校验
        if (StringUtils.isBlank(materialCreateRequest.getGoodsNo())) {
            throw new IllegalArgumentException("货品编码 goodsNo 不能为空");
        }
        if (StringUtils.isBlank(materialCreateRequest.getGoodsName())) {
            throw new IllegalArgumentException("货品名称 goodsName 不能为空");
        }
        // 创建日志记录
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType("JKY");
        pushRecordDTO.setDocNo(materialCreateRequest.getDocNo());
        pushRecordDTO.setDocId(materialCreateRequest.getDocId());

        List<BaseRequestBizData> erpGoodsSkuimPortBatchRequestBizDataList = new ArrayList<>();
        ErpGoodsSkuimPortBatchRequestBizData requestBizData1 = new ErpGoodsSkuimPortBatchRequestBizData();
        requestBizData1.setGoodsName(materialCreateRequest.getGoodsName());
        requestBizData1.setGoodsNo(materialCreateRequest.getGoodsNo());
        requestBizData1.setOutSkuCode(materialCreateRequest.getGoodsNo());
        erpGoodsSkuimPortBatchRequestBizDataList.add(requestBizData1);

//        pushRecordDTO.setReqBody(requestBizData1);
        // 开放平台应用信息
        JackyunResponse jackyunResponse = this.clientService.callBatch(ApiEnum.ERPGOODSSKUIMPORTBATCH.getValue(), erpGoodsSkuimPortBatchRequestBizDataList);

        List<ErpGoodsSkuimPortBatchResponseBizData> responseBizData = null;
        pushRecordDTO.setReqSuccess(true); // 业务调用成功，但实际响应需根据业务判断
//        pushRecordDTO.setRespBody(jackyunResponse);

        log.debug("物料创建接口调用成功，请求参数: [{}], 响应内容: [{}]",
                erpGoodsSkuimPortBatchRequestBizDataList, jackyunResponse);
        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONArray("data").toJavaList(ErpGoodsSkuimPortBatchResponseBizData.class);

        } else {
            pushRecordDTO.setReqSuccess(false); // 业务调用成功，但实际响应需根据业务判断
        }
        // 保存日志记录
        outsidePushRecordRepository.savePushRecord(pushRecordDTO);
        return jackyunResponse;
    }


    /**
     * 供应商更新创建
     */
    @Override
    public JackyunResponse createVendor(VendCreateRequest request) {

        // 记录请求开始
        log.info("开始创建供应商，请求参数: [code={}] [name={}]",
                request.getCode(), request.getName());
        // 创建日志记录
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType("JST");
        pushRecordDTO.setDocNo(request.getDocNo());
        pushRecordDTO.setDocId(request.getDocId());
        ErpVendCreateV2RequestBizData requestBizData = new ErpVendCreateV2RequestBizData();
        requestBizData.setLeader("测试工作人");
        requestBizData.setCode(request.getCode());
        requestBizData.setClassCode(request.getCode());
        requestBizData.setClassName(request.getName());
        requestBizData.setName(request.getName());

//        pushRecordDTO.setReqBody(requestBizData);
        JackyunResponse jackyunResponse = getJackyunResponse(ApiEnum.ERPVENDCREATEV2.getValue(), requestBizData);
        ErpVendCreateV2ResponseBizData responseBizData = null;
        pushRecordDTO.setReqSuccess(true); // 业务调用成功，但实际响应需根据业务判断
//        pushRecordDTO.setRespBody(jackyunResponse);
        log.debug("供应商创建接口调用成功，请求参数: [{}], 响应内容: [{}]", requestBizData, jackyunResponse);

        if (jackyunResponse.isSuccess()) {
            JSONObject response = JsonUtils.deJson(jackyunResponse.toJson(), JSONObject.class);
            responseBizData = response.getJSONObject("result").getJSONObject("data").toJavaObject(ErpVendCreateV2ResponseBizData.class);
        } else {
            pushRecordDTO.setReqSuccess(false); // 业务调用成功，但实际响应需根据业务判断
        }
        // 保存日志记录
        outsidePushRecordRepository.savePushRecord(pushRecordDTO);
        return jackyunResponse;
    }

    /**
     * 发送接口请求并获取数据
     *
     * @param method         Api方法名
     * @param requestBizData 请求参数
     * @return 请求的返回数据
     */
    public JackyunResponse getJackyunResponse(String method, BaseRequestBizData requestBizData) {

        JackyunResponse jackyunResponse = this.clientService.call(method, requestBizData);
        System.out.println(jackyunResponse.toJson());
        return jackyunResponse;
    }

}