package com.elitesland.zhiyuan.openapi.outer.nc.constants;

import lombok.Getter;

/**
 * NC响应状态枚举
 *
 * @author generated
 */
@Getter
public enum NcResponseStatusEnum {

    /**
     * 成功
     */
    SUCCESS("S", "成功"),

    /**
     * 失败
     */
    FAILED("F", "失败");

    private final String code;
    private final String description;

    NcResponseStatusEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    /**
     * 根据代码获取枚举
     */
    public static NcResponseStatusEnum getByCode(String code) {
        if (code == null) {
            return null;
        }
        for (NcResponseStatusEnum status : values()) {
            if (status.getCode().equalsIgnoreCase(code)) {
                return status;
            }
        }
        return null;
    }

    /**
     * 判断是否成功
     */
    public static boolean isSuccess(String code) {
        return SUCCESS.getCode().equalsIgnoreCase(code);
    }

    /**
     * 判断是否失败
     */
    public static boolean isFailed(String code) {
        return FAILED.getCode().equalsIgnoreCase(code);
    }
}