package com.elitesland.zhiyuan.openapi.outer.jushuitan.service;

import com.elitesland.zhiyuan.openapi.outer.jggyun.params.SupplierRequest;
import com.elitesland.zhiyuan.openapi.outer.jggyun.params.UpdateGoodsRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.req.PurchaseInboundListRequest;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.JushuitanBaseResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.PurchaseInboundResponse;
import com.elitesland.zhiyuan.openapi.outer.jushuitan.params.resp.SupplierSyncResponse;

public interface JushuitaService {

    /**
     * 创建物料接口
     */
    JushuitanBaseResponse createMaterial(UpdateGoodsRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception;

    /**
     * 创建供应商
     * @param request 供应商请求参数
     * @param pushRecordInterType 推送记录接口类型
     * @param docId 文档ID
     * @param docNo 文档编号
     * @return {@link SupplierSyncResponse} 供应商同步响应
     */
    SupplierSyncResponse syncSupp(SupplierRequest request, String pushRecordInterType, Long docId, String docNo) throws Exception;

    /**
     * 生成采购入库单
     *
     * @param request 请求
     * @param docId   文档Id
     * @param docNo   文档编号
     * @return {@link PurchaseInboundResponse }
     * @throws Exception 例外
     */
    PurchaseInboundResponse purchaseinCreatebatch(PurchaseInboundListRequest request, Long docId, String docNo) throws Exception;
}