/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.zhiyuan.openapi.outer.jackyun.service;

import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.JackyunResponse;
import com.elitesland.zhiyuan.openapi.outer.jackyun.data.bizdata.core.BaseRequestBizData;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.core.JackyunMemberInfo;
import com.elitesland.zhiyuan.openapi.outer.jackyun.service.core.JackyunOpenHttpUtils;
import com.elitesland.zhiyuan.openapi.outer.jackyun.util.JsonUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class JackyunOpenClientService {
    private static final Logger log = LoggerFactory.getLogger(JackyunOpenClientService.class);
    private final OutsidePushRecordRepository outsidePushRecordRepository;

    public JackyunResponse callApi(String method, BaseRequestBizData bizData, String pushRecordInterType, Long docId, String docNo) {
        JackyunResponse response = null;
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType(pushRecordInterType);
        pushRecordDTO.setDocNo(docNo);
        pushRecordDTO.setDocId(docId);
        pushRecordDTO.setReqSuccess(false);
        pushRecordDTO.setReqBody((Object)JsonUtils.toJson(bizData));
        String strResponse = "";
        JackyunMemberInfo memberInfo = new JackyunMemberInfo();
        try {
            strResponse = JackyunOpenHttpUtils.post(method, "v1.0", JsonUtils.toJson(bizData), memberInfo);
            response = JsonUtils.deJson(strResponse, JackyunResponse.class);
            if (response.isSuccess()) {
                pushRecordDTO.setReqSuccess(true);
            } else {
                pushRecordDTO.setReqSuccess(false);
            }
            pushRecordDTO.setRespBody((Object)response);
            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
        }
        catch (Exception ex) {
            response = new JackyunResponse();
            response.onFail(ex.getMessage(), "CLIENT_EXCEPTION");
            pushRecordDTO.setErrorMsg(ex.getMessage());
            pushRecordDTO.setReqSuccess(false);
            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            return response;
        }
        return response;
    }

    public JackyunResponse call(String method, BaseRequestBizData bizData) {
        JackyunResponse response = null;
        String strResponse = null;
        JackyunMemberInfo memberInfo = new JackyunMemberInfo();
        try {
            strResponse = JackyunOpenHttpUtils.post(method, "v1.0", JsonUtils.toJson(bizData), memberInfo);
        }
        catch (Exception ex) {
            response = new JackyunResponse();
            response.onFail(ex.getMessage(), "CLIENT_EXCEPTION");
            return response;
        }
        return JsonUtils.deJson(strResponse, JackyunResponse.class);
    }

    public JackyunResponse callBatch(String method, List<BaseRequestBizData> bizDataList) {
        JackyunResponse response = null;
        String strResponse = null;
        JackyunMemberInfo memberInfo = new JackyunMemberInfo();
        try {
            strResponse = JackyunOpenHttpUtils.post(method, "v1.0", JsonUtils.toJson(bizDataList), memberInfo);
        }
        catch (Exception ex) {
            response = new JackyunResponse();
            response.onFail(ex.getMessage(), "CLIENT_EXCEPTION");
            return response;
        }
        return JsonUtils.deJson(strResponse, JackyunResponse.class);
    }

    public JackyunResponse callBatchApi(String method, List<BaseRequestBizData> bizDataList, String pushRecordInterType, Long docId, String docNo) {
        JackyunResponse response = null;
        String strResponse = null;
        JackyunMemberInfo memberInfo = new JackyunMemberInfo();
        PushRecordDTO pushRecordDTO = new PushRecordDTO();
        pushRecordDTO.setInterType(pushRecordInterType);
        pushRecordDTO.setDocNo(docNo);
        pushRecordDTO.setDocId(docId);
        pushRecordDTO.setReqSuccess(false);
        pushRecordDTO.setReqBody((Object)JsonUtils.toJson(bizDataList));
        try {
            strResponse = JackyunOpenHttpUtils.post(method, "v1.0", JsonUtils.toJson(bizDataList), memberInfo);
            response = JsonUtils.deJson(strResponse, JackyunResponse.class);
            if (response.isSuccess()) {
                pushRecordDTO.setReqSuccess(true);
            } else {
                pushRecordDTO.setReqSuccess(false);
            }
            pushRecordDTO.setRespBody((Object)response);
            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
        }
        catch (Exception ex) {
            response = new JackyunResponse();
            response.onFail(ex.getMessage(), "CLIENT_EXCEPTION");
            pushRecordDTO.setErrorMsg(ex.getMessage());
            pushRecordDTO.setReqSuccess(false);
            this.outsidePushRecordRepository.savePushRecord(pushRecordDTO);
            return response;
        }
        return response;
    }

    public JackyunOpenClientService(OutsidePushRecordRepository outsidePushRecordRepository) {
        this.outsidePushRecordRepository = outsidePushRecordRepository;
    }
}

